<?php

/* * *************************************************************************
 *
 *   PROJECT: BigWish App
 *   powerd by IT PLUS Team
 *   Copyright 2020 IT Plus Inc
 *   http://it-plus.co/ *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  */

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET,POST,PUT,DELETE,OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

require_once 'init.php';

$postdata = file_get_contents("php://input");
$Req = json_decode($postdata, TRUE);



if ($_GET['action'] == 'getAllUsers') {

    if ($_SERVER['REQUEST_METHOD'] === 'GET') {

        $start         = isset($_GET['start']) ? $_GET['start'] : 0;
        $aItemsPerPage = isset($_GET['aItemsPerPage']) ? $_GET['aItemsPerPage'] : 150;

        $sort = isset($_GET['sort']) ? $_GET['sort'] : 'id';
        $type = isset($_GET['type']) ? $_GET['type'] : 'DESC';

        $searchName = isset($_GET['searchName']) ? $_GET['searchName'] : '';
        $searchUserPhone = isset($_GET['searchUserPhone']) ? $_GET['searchUserPhone'] : '';
        $searchUserStatus = isset($_GET['searchUserStatus']) && $_GET['searchUserStatus'] != '' ? $_GET['searchUserStatus'] : '';



        $usersCount = $userAdmObj->getUsersCount(
            $searchName,
            $searchUserPhone,
            $searchUserStatus
        );

        $users_data = $userAdmObj->getSomeUsers(
            $start,
            $aItemsPerPage,
            $sort,
            $type,
            $searchName,
            $searchUserPhone,
            $searchUserStatus
        );

        $Data = array(
            "success" => true,
            "count" => $usersCount,
            "data" => $users_data
        );
    }
}
if ($_GET['action'] == 'getOneUser') {

    $Req = isset($_GET['id']) ? $_GET['id'] : '';
    $oneUsersData = $userAdmObj->getOneUser($Req);

    if ($oneUsersData) {
        $Data = array(
            'success' => true,
            'data' => $oneUsersData,
        );
    } else {
        $Data = array(
            'success' => false,
            'message' => ['User_does_not_exist'],
        );
    }
}
if ($_GET['action'] == 'addEditUser') {

    $user_id = '';

    $temp = array();

    $allow_ext = array("jpg", "gif", "png", "jpeg", "bmp", "webp");
    $maxsize = 1024 * 20;
    $uploadFolder = $Config['uploads_path'] . 'users';

    $thumbsConfig = array(
        array(
            'name' => 'medium',
            'width' => '240',
            'hight' => '250'
        ),
        array(
            'name' => 'small',
            'width' => '80',
            'hight' => '80'
        ),
    );

    $upload = new Upload($allow_ext, $thumbsConfig, $maxsize, $uploadFolder, false);

    foreach ($_FILES as $key => $img) {
        if (isset($_FILES[$key]['name']) && $_FILES[$key]['name'] != '') {
            $file['name'] = addslashes($_FILES[$key]["name"]);
            $file['type'] = $_FILES[$key]['type'];
            $file['size'] = $_FILES[$key]['size'] / 1024;
            $file['tmp'] = $_FILES[$key]['tmp_name'];
            $file['ext'] = $upload->GetExt($_FILES[$key]["name"]);

            if ($file['name'] != '') {
                $upfile = $upload->Upload_File($file, $maxsize);
                if ($upfile) {
                    $temp[$key] = $upfile['newname'];
                } else {
                    $error = true;
                    $showError[] = $upload->showErrors();
                    $top_msg['error'][] = $showError[0][0];
                    echo $showError[0][0];
                    die();
                }
            }
        } else {
            $temp = null;
        }
    }

    $user_id = $_REQUEST['id'];

    if ($user_id) {
        $userDetailsData = $userAdmObj->getAllDetailsUserData($user_id);
    }

    $data = $userAdmObj->addEditUser($_REQUEST, $temp, $user_id);
    $header = [
        "alg"   => "HS256",
        "typ"   => "JWT"
    ];

    $payload = [
        "user_id"   => $data
    ];

    $token = $hs256Obj->generateJWT('sha256', $header, $payload);
    $returnedData = ['token' => $token, 'userData' => $data];
    $userAdmObj->insertAuthCode($data, $token);


    if ($user_id && $data) {
        if ($temp['img'] != '' && $temp['img'] != null) {
            $old_img = $_SERVER['DOCUMENT_ROOT'] . '/' . $Config['uploads_path'] . 'users/' . $userDetailsData['img'];
            if (file_exists($old_img)) {
                @unlink($old_img);
            }
        }
    }
    $userData = $userAdmObj->getAllDetailsUserData($data);
    $Data = array(
        "success" => true,
        "data" => $userData
    );
}

if ($_GET['action'] == 'deleteUser' && $_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['ids'])) {
        $ids = is_array($_POST['ids']) ? $_POST['ids'] : explode(',', $_POST['ids']);

        $userData = $userAdmObj->deleteUser($ids);
        if ($userData) {
            $Data['data'] = $userData;
            $Data['success'] = true;
        } else {
            $Data['data'] = null;
            $Data['msg'] = 'no_data';
            $Data['success'] = false;
        }
    } else {
        $Data['msg'] = 'No ID provided';
        $Data['success'] = false;
    }
}

if ($_GET['action'] == 'getUserLevel') {

    $userLevelData = $userAdmObj->getUserLevel($Req);
    if ($userLevelData) {
        $Data = array(
            'success' => true,
            'data' => $userLevelData,
        );
    } else {
        $Data = array(
            'success' => false,
            'message' => ['User_does_not_exist'],
        );
    }
}
if ($_GET['action'] == 'getUsersLevels') {

    $leveltype = $_GET['level_type'] ? $_GET['level_type'] : "admin";
    $usersLevelsData = $userAdmObj->getUsersLevels($leveltype);
    if ($usersLevelsData) {
        $Data = array(
            'success' => true,
            'data' => $usersLevelsData,
        );
    } else {
        $Data = array(
            'success' => false,
            'message' => ['User_does_not_exist'],
        );
    }
}







echo json_encode($Data);
