<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET,POST,PUT,DELETE,OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

require_once 'init.php';

header('Content-Type: application/json; charset=utf-8');

$Req = json_decode(file_get_contents("php://input"), true);
$action = $_GET['action'] ?? '';



// 🟢 إرسال OTP
if ($action === 'request_otp') {
    if (empty($Req['email'])) {
        echo json_encode(['status' => false, 'message' => 'يرجى إدخال البريد الإلكتروني']);
        exit;
    }

    $email = trim(strtolower($Req['email']));

    // تحقق إذا كان موجود فعلاً
    if ($usersObj->checkEmail($email)) {
        echo json_encode(['status' => true, 'message' => 'البريد الإلكتروني مسجل بالفعل',
    'page_to'=>'login']);
        exit;
    }

    // توليد OTP وتشفيره
    $otp = rand(100000, 999999);
    $hashedOtp = password_hash($otp, PASSWORD_DEFAULT);

    // هل المستخدم موجود مؤقتًا بنفس الإيميل؟
    $userId = $usersObj->getUserIdByEmail($email);
    if ($userId) {
        $usersObj->insertAuthCode($userId, $hashedOtp); // تحديث الكود
    } else {
        $userId = $usersObj->createTempUser($email);
        $usersObj->insertAuthCode($userId, $hashedOtp); // تخزين الكود
    }

    // إرسال البريد (اختياري)
    $registerObj->sendOtpEmail($email, $otp);

    echo json_encode([
        'status' => 200,
        'message' => 'تم إرسال رمز التفعيل إلى بريدك الإلكتروني',
        'email' => $email
    ]);
    exit;
}


if ($action === 'verify_otp') {
    if (empty($Req['email']) || empty($Req['otp'])) {
        echo json_encode(['status' => false, 'message' => 'يرجى إدخال البريد وكود التفعيل']);
        exit;
    }

    $email = trim(strtolower($Req['email']));
    $otpInput = trim($Req['otp']);

    $user = $usersObj->getUserByEmail($email);
    if (!$user) {
        echo json_encode(['status' => false, 'message' => 'البريد الإلكتروني غير موجود']);
        exit;
    }

    $storedHashedOtp = $user['authentication_code'];

    if (!password_verify($otpInput, $storedHashedOtp)) {
        echo json_encode(['status' => false, 'message' => 'كود التفعيل غير صحيح']);
        exit;
    }

    // // ✅ التحقق تم بنجاح، نحذف الكود
    // $usersObj->deleteAuthCode($user['id']);

    echo json_encode([
        'status' => true,
        'message' => 'تم التحقق بنجاح، يمكنك استكمال التسجيل',
        'page_to' => 'register',
        'user_id' => $user['id']
    ]);
    exit;
}

// 🔵 استكمال التسجيل بعد التحقق
if ($action === 'complete_registration') {
    $response = $registerObj->completeRegistration($Req);
    echo json_encode($response, JSON_UNESCAPED_UNICODE);
    exit;
}



if($action === 'login') {
    // تحقق من وجود البريد وكلمة المرور
if (empty($Req['email']) || empty($Req['password'])) {
    echo json_encode(['status' => 400, 'message' => 'يرجى إدخال البريد وكلمة المرور']);
    exit;
}

$email = trim(strtolower($Req['email']));
$password = trim($Req['password']);


$response = $registerObj->loginUser($email, $password);

echo json_encode($response, JSON_UNESCAPED_UNICODE);
exit;
//////////////////////////////////////////////////////////////////////////////////////////
}
