<?php

/*************************************************************************
 *
 *   PROJECT: Tahalya app - Categories API
 *   powered by IT PLUS Team
 *   Copyright 2020 IT Plus Inc
 *   http://it-plus.co/
 * *************************************************************************/

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET,POST,PUT,DELETE,OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

require_once 'init.php';

$postdata = file_get_contents("php://input");
$Req = json_decode($postdata, TRUE);

if ($_GET['action'] === 'Reaction') {
    // 🔹 استخراج القيم من JSON Body
    $comment_id = isset($Req['comment_id']) ? intval($Req['comment_id']) : 0;
    $user_id = isset($Req['user_id']) ? intval($Req['user_id']) : 0;
$reaction_type  = isset($Req['reaction_type']) ? trim(strtolower($Req['reaction_type'])) : '';
$mode = isset($Req['mode']) ? trim(strtolower($Req['mode'])) : 'comment';
if ($comment_id > 0 && $user_id > 0 && !empty($reaction_type) && !empty($mode)) {
    $addedData = $comment_reactionsObj->likeOrDislikeCommentAndArtticle($comment_id, $user_id, $reaction_type,$mode);
}else{
    $addedData = ['status' => 400, 'message' => 'comment_id , user_id ,  reaction_type required ,mode'];
}
    $Data = [];
    if ($addedData['status'] == 200) {
        $Data['success'] = true;
        $Data['data'] = $addedData;
    } else {
        $Data['success'] = false;
        $Data['msg'] = $addedData['message'];
    }
}

if ($_GET['action'] === 'GetCount') {
    $comment_id = isset($Req['comment_id']) ? intval($Req['comment_id']) : 0;
    if (!$comment_id) {
        echo json_encode(['status' => 400, 'message' => 'comment_id مطلوب'], JSON_UNESCAPED_UNICODE);
        exit;
    }

    $result = $comment_reactionsObj->getReactionsCount($comment_id);
    echo json_encode($result, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
}

if ($_GET['action'] === 'GetUserReaction') {
    $comment_id = isset($Req['comment_id']) ? intval($Req['comment_id']) : 0;
    $user_id = isset($Req['user_id']) ? intval($Req['user_id']) : 0;

    if (!$comment_id || !$user_id) {
        echo json_encode(['status' => 400, 'message' => 'comment_id و user_id مطلوبين'], JSON_UNESCAPED_UNICODE);
        exit;
    }

    $result = $comment_reactionsObj->getUserReactionForComment($comment_id, $user_id);
    echo json_encode($result, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    exit;
}



header('Content-Type: application/json');
echo json_encode($Data, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
exit;
