<?php
date_default_timezone_set('Africa/Cairo');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET,POST,PUT,DELETE,OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, User-Token, Authorization, X-Requested-With, access-control-allow-origin, lang-code');



// Function to mimic apache_request_headers() if not available
if (!function_exists('apache_request_headers')) {
    function apache_request_headers()
    {
        $arh = array();
        $rx_http = '/\AHTTP_/';
        foreach ($_SERVER as $key => $val) {
            if (preg_match($rx_http, $key)) {
                $arh_key = preg_replace($rx_http, '', $key);
                $rx_matches = array();
                // Restore original letter case
                $rx_matches = explode('_', strtolower($arh_key));
                if (count($rx_matches) > 0 && strlen($arh_key) > 2) {
                    foreach ($rx_matches as $ak_key => $ak_val)
                        $rx_matches[$ak_key] = ucfirst($ak_val);
                    $arh_key = implode('-', $rx_matches);
                }
                $arh[$arh_key] = $val;
            }
        }
        if (isset($_SERVER['CONTENT_TYPE']))
            $arh['Content-Type'] = $_SERVER['CONTENT_TYPE'];
        if (isset($_SERVER['CONTENT_LENGTH']))
            $arh['Content-Length'] = $_SERVER['CONTENT_LENGTH'];
        return $arh;
    }
}

$headers = apache_request_headers();

// print_r($headers);die();
$langCode = isset($headers['Lang-Code']) ? $headers['Lang-Code'] : 'en';
// $data_offset = isset($headers['Date-Offset']) ? $headers['Date-Offset'] : 'Africa/Cairo'; 

$supportedLanguages = ['en', 'ar'];


define('LANGUAGE', in_array($langCode, $supportedLanguages) ? $langCode : 'en');
// define('TIME_ZONE', $headers['Date-Offset']);

require_once '../includes/config.inc.php';
require_once 'classes/plusMailer.php';
require_once 'classes/upload-class.php';
require_once 'classes/iplus.php';
require_once 'classes/class.hs256.php';
require_once 'classes/class.users.php';
require_once 'classes/class.pages.php';
require_once 'classes/class.comments.php';
require_once 'classes/class.reactions.php';

require_once 'classes/class.banks.php';
require_once 'classes/class.branches.php';
require_once 'classes/class.atms.php';
require_once 'classes/class.banners.php';
require_once 'classes/class.categories.php';
require_once 'classes/class.articles.php';
require_once 'classes/class.register.php';


// 🟡 حدد الـ action المطلوب حمايته بالتوكن فقط
$actionsRequireToken = ['getComments', 'addComment', 'likeComment', 'dislikeComment', 'getOneArticle']; // أضف اللي تحبه

$currentAction = isset($_GET['action']) ? $_GET['action'] : null;

if (in_array($currentAction, $actionsRequireToken)) {
     $db = iplus::$handel ?? (new iplus())->connect(); // تأكد من الاتصال
    $token = $usersObj->getBearerToken();
    if (isset($token)) {
        $AuthUser = $usersObj->authenticateUserByToken($token);
    } else {
        $id_user = 0; // افتراضيًا: زائر
        $headers = getallheaders();
        if (isset($headers['Authorization']) && !empty($headers['Authorization'])) {
            $token = str_replace('Bearer ', '', trim($headers['Authorization']));
            $authUser = $usersObj->authenticateUserByToken($token);

            if ($authUser) {
                $id_user = intval($authUser['id']);
            }
        }
        // 🟢 خزّن المستخدم في متغير عام لاستخدامه في ملفات الـ API
        $GLOBALS['AuthUser'] = $AuthUser;
        // تم تسجليه في متغير جلوبلز بحيث يتم استدعاءه فيالريكوستات بطريقة معينة
        //$id_user = isset($GLOBALS['AuthUser']) ? $GLOBALS['AuthUser']['id'] : 0;
        //او كده $id_user = $AuthUser['id'];
        //دي طريقة الاستدعاء 
    }

}