<?php

/*************************************************************************
 *
 *   PROJECT: Tahalya app - Categories API
 *   powered by IT PLUS Team
 *   Copyright 2020 IT Plus Inc
 *   http://it-plus.co/
 * *************************************************************************/

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET,POST,PUT,DELETE,OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

require_once 'init.php';

$postdata = file_get_contents("php://input");
$Req = json_decode($postdata, TRUE);

if ($_GET['action'] == 'addEditComment') {
    $result = $commentsObj->addEditComment($Req);

    if (isset($result['status']) && $result['status'] == 500) {
        $Data['data'] = $result;
        $Data['success'] = false;
        $Data['msg'] = 'failed';
    } else {
        // ✅ (اختياري) جلب التعليقات المحدثة للمقال
        $updatedComments = [];
        if (isset($Req['id_article'])) {
            $updatedComments = $commentsObj->getCommentsWithReplies($Req['id_article']);
        }

        $Data['data'] = [
            'comment' => $result

        ];
        $Data['success'] = true;
        $Data['msg'] = 'success';
    }

    echo json_encode($Data, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    exit;
}



if ($_GET['action'] == 'deleteComment') {
    if (!isset($Req['ids']) || !is_array($Req['ids'])) {
        $Data = [
            "status" => 400,
            "message" => "Missing or invalid 'ids' parameter. Provide an array of comment IDs."
        ];
    } else {
        $Data = $commentsObj->deleteComments($Req['ids']);
    }

    echo json_encode($Data);
    exit;
}

if ($_GET['action'] == 'getComments') {

    $id_article = isset($_GET['id_article']) ? intval($_GET['id_article']) : 0;
    $aStart     = isset($_GET['aStart']) ? intval($_GET['aStart']) : 0;
    $aLimit     = isset($_GET['aLimit']) ? intval($_GET['aLimit']) : 10;
    $parent_id  = isset($_GET['parent_id']) ? intval($_GET['parent_id']) : null;

    // ✅ مستخدم معتمد من init.php
    $id_user = $AuthUser['id'];
    //هنا رجع بال id_user من التوكن
    
    if ($id_article <= 0) {
        $Data = [
            "status" => 400,
            "success" => false,
            "msg" => "يجب إرسال معرف المقال (id_article) بشكل صحيح"
        ];
    } else {
        $commentsList = $commentsObj->getCommentsWithReplies($id_article, $aStart, $aLimit, $id_user, $parent_id);

        $Data = [
            "status" => 200,
            "success" => true,
            "msg" => "تم جلب التعليقات بنجاح",
            "data" => $commentsList
        ];
    }

    echo json_encode($Data, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    exit;
}





header('Content-Type: application/json');
echo json_encode($Data);
