<?php

$usersObj = new users();

class users
{

    var $mDb;
    var $mConfig;
    var $mlang;


    function __construct()
    {
        global $Config;
        global $Lang;
        $this->mDb = new iplus();
        $this->mConfig = $Config;
        $this->mlang = $Lang;
    }

    function convert_object_to_array($data)
    {
        if (is_object($data)) {
            $data = get_object_vars($data);
        }

        if (is_array($data)) {
            return array_map(__METHOD__, $data);
        } else {
            return $data;
        }
    }

    public function authenticateUserByToken($token)
    {
        $db = $this->mDb->connect();
        if (!$token) return null;

        $stmt = $db->prepare("SELECT id, full_name FROM users WHERE TRIM(authentication_code) = :token AND status = 1 LIMIT 1");
        $stmt->execute([':token' => trim($token)]);
        return $stmt->fetch(PDO::FETCH_ASSOC) ?: null;
    }

    function getBearerToken()
    {
        $headers = apache_request_headers();
        if (!isset($headers['Authorization'])) {
            return null;
        }

        if (preg_match('/Bearer\s(\S+)/', $headers['Authorization'], $matches)) {
            return trim($matches[1]);
        }

        return null;
    }

    public function getSomeUsers($aStart, $aLimit, $sort = 'id', $type = 'DESC', $searchName = null, $searchUserPhone = null, $searchUserStatus = null)
    {
        $result = [];
        $pdo = $this->mDb->connect();

        $sql = "SELECT u.*, u.full_name as added_by
            FROM `users` u
            LEFT JOIN `user_levels` ul ON ul.id = u.user_level
            WHERE u.id > 0";

        if ($searchName) {
            $sql .= " AND u.full_name LIKE :searchName";
        }
        if ($searchUserPhone) {
            $sql .= " AND u.mobile LIKE :searchUserPhone";
        }
        if ($searchUserStatus !== null && $searchUserStatus !== '') {
            $sql .= " AND u.status = :searchUserStatus";
        }

        $allowedSortFields = ['id', 'full_name', 'mobile', 'status', 'date_added', 'type'];
        $sort = in_array($sort, $allowedSortFields) ? "u.{$sort}" : "u.id";
        $type = strtoupper($type) === 'ASC' ? 'ASC' : 'DESC';

        $sql .= " ORDER BY {$sort} {$type} LIMIT :aStart, :aLimit";

        try {
            $pdo->beginTransaction();
            $stmt = $pdo->prepare($sql);

            if ($searchName) {
                $searchName = "%$searchName%";
                $stmt->bindParam(':searchName', $searchName, PDO::PARAM_STR);
            }
            if ($searchUserPhone) {
                $searchUserPhone = "%$searchUserPhone%";
                $stmt->bindParam(':searchUserPhone', $searchUserPhone, PDO::PARAM_STR);
            }
            if ($searchUserStatus !== null && $searchUserStatus !== '') {
                $stmt->bindParam(':searchUserStatus', $searchUserStatus, PDO::PARAM_STR);
            }

            $stmt->bindValue(':aStart', (int)$aStart, PDO::PARAM_INT);
            $stmt->bindValue(':aLimit', (int)$aLimit, PDO::PARAM_INT);

            $stmt->execute();
            $result = $stmt->fetchAll(PDO::FETCH_ASSOC);

            $pdo->commit();
        } catch (Exception $e) {
            $pdo->rollBack();
            error_log("Exception in getSomeUsers: " . $e->getMessage());
        }

        return $result;
    }

    public function getUsersCount($searchName = null, $searchUserPhone = null, $searchUserStatus = null)
    {
        $pdo = $this->mDb->connect();
        $result = 0;

        $sql = "SELECT COUNT(u.id) as count FROM `users` u WHERE u.id > 0";

        if ($searchName) {
            $sql .= " AND u.full_name LIKE :searchName";
        }
        if ($searchUserPhone) {
            $sql .= " AND u.mobile LIKE :searchUserPhone";
        }
        if ($searchUserStatus !== null && $searchUserStatus !== '') {
            $sql .= " AND u.status = :searchUserStatus";
        }

        try {
            $pdo->beginTransaction();
            $stmt = $pdo->prepare($sql);

            if ($searchName) {
                $searchName = "%$searchName%";
                $stmt->bindParam(':searchName', $searchName, PDO::PARAM_STR);
            }
            if ($searchUserPhone) {
                $searchUserPhone = "%$searchUserPhone%";
                $stmt->bindParam(':searchUserPhone', $searchUserPhone, PDO::PARAM_STR);
            }
            if ($searchUserStatus !== null && $searchUserStatus !== '') {
                $stmt->bindParam(':searchUserStatus', $searchUserStatus, PDO::PARAM_STR);
            }

            $stmt->execute();
            $result = $stmt->fetch(PDO::FETCH_ASSOC)['count'];

            $pdo->commit();
        } catch (Exception $e) {
            $pdo->rollBack();
            error_log("Exception in getUsersCount: " . $e->getMessage());
        }

        return $result;
    }


    public function getOneUser($id)
    {
        $pdo = $this->mDb->connect();
        $result = [];

        try {
            $pdo->beginTransaction();

            $sql = "SELECT u.`id`, u.`email`, u.`full_name`, u.`mobile`, 
                       u.`img`, u.`user_level`,
                       u.`notes`, u.`status`, u.`date_added` 
                FROM `users` u 
                LEFT JOIN `user_levels` ul ON ul.id = u.user_level 
                WHERE u.`id` = :id";

            $stmt = $pdo->prepare($sql);
            $stmt->bindParam(':id', $id, PDO::PARAM_INT);
            $stmt->execute();

            $result = $stmt->fetch(PDO::FETCH_ASSOC);

            $pdo->commit();
        } catch (Exception $e) {
            $pdo->rollBack();
            error_log("Exception in getOneUser: " . $e->getMessage());
        }

        return $result;
    }

    function addEditUser($request, $temp, $user_id)
    {
        unset($request['action']);
        $pdo = $this->mDb->connect();
        $dateTime = date('Y-m-d');
        $res = false;

        try {
            // Start a transaction
            $pdo->beginTransaction();

            if (empty($user_id)) { // Insert logic
                // if (($request['email'])) {
                //     $emailExists = $this->checkEmail($request['email']);
                //     if ($emailExists) {
                //         throw new Exception("Email already exists");
                //         die();
                //     }
                // }

                $request['password'] = password_hash($request['password'], PASSWORD_DEFAULT);

                $sql = "INSERT INTO `users` (`full_name`, `email`,  `mobile`,  `password`,  `added_by`, `user_level`, `img`, `date_added`, `notes`, `status`) 
                    VALUES (:full_name, :email, :mobile, :password, :added_by, :user_level, :img, :date_added, :notes, :status)";
                $stmt = $pdo->prepare($sql);

                $stmt->bindParam(':full_name', $request['full_name']);
                $stmt->bindParam(':email', $request['email']);
                $stmt->bindParam(':mobile', $request['mobile']);
                $stmt->bindParam(':password', $request['password']);
                $stmt->bindParam(':added_by', $request['added_by']);
                $stmt->bindParam(':user_level', $request['user_level']);
                $stmt->bindParam(':status', $request['status']);
                $stmt->bindParam(':img', $temp['img']);
                $stmt->bindParam(':date_added', $dateTime);
                $stmt->bindParam(':notes', $request['notes']);

                if (!$stmt->execute()) {
                    throw new Exception("Error inserting the user: " . implode(", ", $stmt->errorInfo()));
                }

                $id = $pdo->lastInsertId();

                // Commit the transaction
                $pdo->commit();
                return $id;
            } else { // Update logic
                $sql = "UPDATE `users` SET 
                        `full_name` = :full_name, 
                        `mobile` = :mobile, ";

                if (!empty($request['password'])) {
                    $sql .= "`password` = :password, ";
                }
                if (!empty($temp['img'])) {
                    $sql .= "`img` = :img, ";
                }

                $sql .= "   `added_by` = :added_by, 
                        `email` = :email, 
                        `user_level` = :user_level, 
                        `date_added` = :date_added, 
                        `status` = :status, 
                        `notes` = :notes
                    WHERE `id` = :id";

                $stmt = $pdo->prepare($sql);

                $stmt->bindParam(':full_name', $request['full_name']);
                $stmt->bindParam(':email', $request['email']);
                $stmt->bindParam(':mobile', $request['mobile']);
                $stmt->bindParam(':status', $request['status']);
                if (!empty($request['password'])) {
                    $stmt->bindParam(':password', password_hash($request['password'], PASSWORD_DEFAULT));
                }
                if (!empty($temp['img'])) {
                    $stmt->bindParam(':img', $temp['img']);
                }
                $stmt->bindParam(':added_by', $request['added_by']);
                $stmt->bindParam(':user_level', $request['user_level']);
                $stmt->bindParam(':date_added', $dateTime);
                $stmt->bindParam(':notes', $request['notes']);
                $stmt->bindParam(':id', $user_id);

                if (!$stmt->execute()) {
                    throw new Exception("Error updating the user: " . implode(", ", $stmt->errorInfo()));
                }

                $res = $stmt->rowCount() > 0;

                // Commit the transaction
                $pdo->commit();
                return $res ? $user_id : false;
            }
        } catch (Exception $e) {
            // Rollback on any failure
            $pdo->rollBack();
            error_log("Exception: " . $e->getMessage());
            return [
                "status" => false,
                "message" => $e->getMessage(),
            ];
        } catch (PDOException $e) {
            // Rollback on database error
            $pdo->rollBack();
            error_log("PDOException: " . $e->getMessage());
            return [
                "status" => false,
                "message" => $e->getMessage(),
            ];
        }
    }

    function getAllDetailsUserData($id)
    {
        try {
            // print_r($id);die;
            $pdo = $this->mDb->connect();

            $query = "SELECT u.id, u.password, u.full_name, u.mobile, u.img, u.user_level, 
                         u.notes, u.status, u.date_added
                  FROM `users` u
                  WHERE u.id = :id";

            $stmt = $pdo->prepare($query);
            $stmt->bindParam(':id', $id, PDO::PARAM_INT);

            if ($stmt->execute()) {
                return $stmt->fetch(PDO::FETCH_ASSOC);
            } else {
                throw new Exception("Error executing query: " . implode(", ", $stmt->errorInfo()));
            }
        } catch (PDOException $e) {
            error_log("PDOException in getAllDetailsUserData: " . $e->getMessage());
            return false;
        } catch (Exception $e) {
            error_log("Exception in getAllDetailsUserData: " . $e->getMessage());
            return false;
        }
    }

    function insertAuthCode($aId, $authentication_code)


    {
        $sql = " UPDATE `users` SET `authentication_code` = '{$authentication_code}'";
        $sql .= " WHERE `id` = '{$aId}'";
        // echo $sql; die();
        return $this->mDb->query($sql);
    }

    public function createTempUser($email)
    {
        $stmt = $this->mDb->connect()->prepare("INSERT INTO users (email, date_added) VALUES (?, NOW())");
        $stmt->execute([$email]);
        return $this->mDb->connect()->lastInsertId();
    }

    function checkEmail($email)
    {
        try {
            $sql = "SELECT u.email FROM `users` u WHERE u.`email` = :email";

            $stmt = $this->mDb->connect()->prepare($sql);
            $stmt->bindParam(':email', $email, PDO::PARAM_STR);
            $stmt->execute();

            $result = $stmt->fetch(PDO::FETCH_ASSOC);
            return $result !== false;
        } catch (PDOException $e) {
            error_log("Error in checkEmail: " . $e->getMessage());
            return false;
        }
    }

    public function getUserByEmail($email)
    {
        $stmt = $this->mDb->connect()->prepare("SELECT * FROM users WHERE email = ?");
        $stmt->execute([$email]);
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }

        public function getUserIdByEmail($email)
    {
        $stmt = $this->mDb->connect()->prepare("SELECT id FROM users WHERE email = ?");
        $stmt->execute([$email]);
        return $stmt->fetchColumn();
    }
    public function deleteUser($ids)
    {
        if (empty($ids) || !is_array($ids)) {
            return false;
        }

        $pdo = $this->mDb->connect();
        $result = [];

        try {
            $pdo->beginTransaction();

            $placeholders = implode(',', array_fill(0, count($ids), '?'));
            $sql = "SELECT `img` FROM `users` WHERE `id` IN ($placeholders)";
            $stmt = $pdo->prepare($sql);
            $stmt->execute($ids);
            $result = $stmt->fetchAll(PDO::FETCH_ASSOC);

            foreach ($result as $user) {
                $old_img = $_SERVER['DOCUMENT_ROOT'] . '/' . $this->mConfig['uploads_path'] . 'users/' . $user['img'];
                if (file_exists($old_img)) {
                    @unlink($old_img);
                }
            }

            $sqlDelete = "DELETE FROM `users` WHERE `id` IN ($placeholders)";
            $stmtDelete = $pdo->prepare($sqlDelete);
            $stmtDelete->execute($ids);

            $pdo->commit();
            return true;
        } catch (PDOException $e) {
            $pdo->rollBack();
            error_log("Error in deleteUser: " . $e->getMessage());
            return false;
        }
    }
   public function deleteAuthCode($userId)
    {
        $stmt = $this->mDb->connect()->prepare("UPDATE users SET authentication_code = NULL WHERE id = ?");
        return $stmt->execute([$userId]);
    }
    public function getUserLevel($request)
    {
        $pdo = $this->mDb->connect();
        $user_id = $request['user_id'];
        $roles = $request['roles'];

        $select = implode(", ", array_map(function ($role) {
            return "ul.$role";
        }, $roles));

        $query = "SELECT u.`id` AS 'user_id_in_users', {$select} 
              FROM `users` u 
              LEFT JOIN `user_levels` ul ON ul.id = u.user_level 
              WHERE u.`id` = :user_id";


        try {
            $pdo->beginTransaction();

            $stmt = $pdo->prepare($query);
            $stmt->bindParam(':user_id', $user_id, PDO::PARAM_INT);

            if ($stmt->execute()) {
                $pdo->commit();
                return $stmt->fetch(PDO::FETCH_ASSOC);
            } else {
                $pdo->rollBack();
            }
        } catch (PDOException $e) {
            $pdo->rollBack();
            error_log("Error in getUserLevel: " . $e->getMessage());
            return false;
        }
    }
    public function getUsersLevels($leveltype)
    {
        $pdo = $this->mDb->connect();

        $sql = "SELECT `id`, `level_name` FROM `user_levels`";

        try {
            $pdo->beginTransaction();
            $stmt = $pdo->prepare($sql);
            if ($stmt->execute()) {
                $pdo->commit();
                return $stmt->fetchAll(PDO::FETCH_ASSOC);
            } else {
                $pdo->rollBack();
                return false;
            }
        } catch (PDOException $e) {
            $pdo->rollBack();
            error_log("Error in getUsersLevels: " . $e->getMessage());
            return false;
        }
    }
}
