<?php
$registerObj = new register();
require_once '../vendor/autoload.php';

class register
{

    var $mDb;
    var $mConfig;
    var $mlang;

    function __construct()
    {
        session_start();
        global $Config;
        global $lang;
        $this->mDb = new iplus();
        $this->mConfig = $Config;
        $this->mlang = $lang;
    }

    function convert_object_to_array($data)
    {
        if (is_object($data)) {
            $data = get_object_vars($data);
        }
        if (is_array($data)) {
            return (array_map(__METHOD__, $data));
        } else {
            return $data;
        }
    }


    // 🟢 مرحلة إرسال OTP وتخزين البيانات مؤقتًا
    public function completeRegistration($data)
{
    $required = ['email', 'full_name', 'mobile', 'password'];
    foreach ($required as $field) {
        if (empty($data[$field])) {
            return ['status' => false, 'message' => "الحقل $field مطلوب"];
        }
    }

    $email    = trim(strtolower($data['email']));
    $name     = trim($data['full_name']);
    $phone    = trim($data['mobile']);
    $password = password_hash($data['password'], PASSWORD_DEFAULT);

    $db = $this->mDb->connect();

    // 🟡 جلب المستخدم المؤقت (تم التحقق من OTP)
    $stmt = $db->prepare("SELECT id FROM users WHERE email = ? ");
    $stmt->execute([$email]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$user) {
        return ['status' => false, 'message' => 'لم يتم العثور على مستخدم تم التحقق منه'];
    }

    $userId = $user['id'];

    // ❗ تحقق أن الإيميل غير مستخدم من شخص آخر
    $stmt = $db->prepare("SELECT id FROM users WHERE email = ? AND id != ?");
    $stmt->execute([$email, $userId]);
    if ($stmt->rowCount() > 0) {
        return ['status' => false, 'message' => 'البريد الإلكتروني مستخدم من حساب آخر'];
    }

    // 🟢 تحديث بيانات المستخدم المؤقت ليصبح مكتمل
    $stmt = $db->prepare("UPDATE users 
                        SET full_name = ?, mobile = ?, password = ?, status = '1', added_by = '1', user_level = '2'
                        WHERE id = ?");
    $stmt->execute([$name, $phone, $password, $userId]);

    $stmt = $db->prepare("SELECT  full_name, email,mobile,user_level,status ,authentication_code FROM users WHERE id = ?");
    $stmt->execute([$userId]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

            $data= $this->return_Data($userId);

    return [
        'status' => 200,
        'message' => 'تم استكمال التسجيل بنجاح',
        'page_to' => 'login',
        'Data' => $data
    ];
}




    // 🔵 مرحلة التحقق من OTP وتسجيل الحساب فعليًا

    public function verifyOTP($email, $otpFromClient)
    {
        // في الواقع لا يوجد تخزين، لذلك التحقق بيكون خارجي (الفرونتند يحتفظ بالـ OTP المرسل ويقارن)
        if (!isset($otpFromClient) || !is_numeric($otpFromClient)) {
            return ['status' => 400, 'message' => 'كود التفعيل غير صالح'];
        }

        return [
            'status' => 200,
            'message' => 'تم التحقق بنجاح، يمكنك استكمال التسجيل'
        ];
    }

    // ✉️ دالة إرسال OTP عبر Gmail باستخدام PHPMailer
    function sendOtpEmail($email, $otp)
    {

        $mail = new \PHPMailer\PHPMailer\PHPMailer(true);
        // $otp = rand(100000, 999999);
        try {
            $mail->isSMTP();
            $mail->Host = 'smtp.gmail.com';
            $mail->SMTPAuth = true;
            $mail->Username = 'mohamedibrahim55255@gmail.com';
            $mail->Password = 'afksyhwhzrikutaq';
            $mail->SMTPSecure = 'tls';
            $mail->Port = 587;
            $mail->setFrom('your_email@gmail.com', 'BankTime');
            $mail->addAddress($email);
            $mail->isHTML(true);
            $mail->Subject = 'رمز التفعيل';
            $mail->Body    = "رمز التفعيل الخاص بك هو: <b>$otp</b>";

            $mail->send();
            return true;
        } catch (\Exception $e) {
            file_put_contents('mail_error.txt', $mail->ErrorInfo);
            return false;
        }
    }

    public function loginUser($email, $password)
    {
        $db = $this->mDb->connect();
        try {
            $stmt = $db->prepare("SELECT id, full_name, email, password,  status FROM users WHERE email = ? LIMIT 1");
            $stmt->execute([$email]);
            $user = $stmt->fetch(PDO::FETCH_ASSOC);

            if (!$user) {
                return ['status' => 404, 'message' => 'البريد الإلكتروني غير مسجل'];
            }

            if ($user['status'] !== '1') {
                return ['status' => 403, 'message' => 'الحساب غير مفعل أو معطل'];
            }

            // مقارنة كلمة المرور
            if (!password_verify($password, $user['password'])) {
                return ['status' => 401, 'message' => 'كلمة المرور غير صحيحة'];
            }

            // ✅ تسجيل دخول ناجح
            $data= $this->return_Data($user['id']);

            return [
                'status' => true,
                'message' => 'تم تسجيل الدخول بنجاح',   
                'page_to' => 'home',
                'date'=>$data
            ];
        } catch (PDOException $e) {
            error_log("Login error: " . $e->getMessage());
            return ['status' => 500, 'message' => 'حدث خطأ أثناء تسجيل الدخول'];
        }
    }


    //دالة يمكن استخدمها في حالة عرض النتيجة بداتا معينة بحيث تكون ثابتة في كل  الريسبونس
    public function return_Data($id){
        $db = $this->mDb->connect();
        $stmt = $db->prepare("SELECT id, full_name, email, mobile, user_level, status,authentication_code FROM users WHERE id = ?");
        $stmt->execute([$id]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);

        if (!$user) {
            return ['status' => false, 'message' => 'لم يتم العثور على المستخدم'];
        }

        return $user;

    }


}


