<?php
$comment_reactionsObj = new comment_reactions();

class comment_reactions
{


    var $mDb;
    var $mConfig;
    var $mlang;

    function __construct()
    {
        global $Config;
        global $Lang;
        $this->mDb = new iplus();
        $this->mConfig = $Config;
        $this->mlang = $Lang;
    }

    function convert_object_to_array($data)
    {
        if (is_object($data)) {
            $data = get_object_vars($data);
        }

        if (is_array($data)) {
            return array_map(__METHOD__, $data);
        } else {
            return $data;
        }
    }



    public function likeOrDislikeCommentAndArtticle($mode_id, $user_id, $reaction_type, $mode = 'comment')
    {
        try {
            $mode_id = intval($mode_id);
            $user_id = intval($user_id);
            $reaction_type = trim(strtolower($reaction_type));
            $mode = trim(strtolower($mode));
            $allowedTypes = ["like", "dislike"];
            $allowedModes = ["comment","article"]; 

            if (empty($reaction_type) || !in_array($reaction_type, $allowedTypes)) {
                return ['status' => 400, 'message' => 'نوع التفاعل غير مسموح به'];
            }

            if (empty($mode) || !in_array($mode, $allowedModes)) {
                return ['status' => 400, 'message' => 'نوع المحتوى غير صالح'];
            }

            $db = $this->mDb->connect();

            // التحقق إذا كان نفس التفاعل موجود بالفعل
            $stmt = $db->prepare("SELECT * FROM mode_reactions 
                    WHERE mode_id = :mode_id AND user_id = :user_id AND reaction_type = :reaction_type AND mode = :mode");

            $stmt->execute([
                ':mode_id' => $mode_id,
                ':user_id' => $user_id,
                ':reaction_type' => $reaction_type,
                ':mode' => $mode
            ]);

            $existing = $stmt->fetch(PDO::FETCH_ASSOC);

            if ($existing) {
                // حذف التفاعل إذا كان موجود مسبقًا بنفس النوع
                $removeStmt = $db->prepare("DELETE FROM mode_reactions 
                                        WHERE mode_id = :mode_id AND user_id = :user_id AND reaction_type = :reaction_type AND mode = :mode");
                $removeStmt->execute([
                    ':mode_id' => $mode_id,
                    ':user_id' => $user_id,
                    ':reaction_type' => $reaction_type,
                    ':mode' => $mode
                ]);

                return ['status' => 200, 'message' => 'تم حذف التفاعل السابق'];
            }

            // إضافة أو تحديث التفاعل
            $stmt = $db->prepare("INSERT INTO mode_reactions (mode_id, user_id, reaction_type, date_added, mode)
                              VALUES (:mode_id, :user_id, :reaction_type, NOW(), :mode)
                              ON DUPLICATE KEY UPDATE reaction_type = :reaction_type");

            $stmt->execute([
                ':mode_id' => $mode_id,
                ':user_id' => $user_id,
                ':reaction_type' => $reaction_type,
                ':mode' => $mode
            ]);

            return ['status' => 200, 'message' => 'تم حفظ التفاعل بنجاح'];
        } catch (PDOException $e) {
            return ['status' => 500, 'message' => 'Database Error: ' . $e->getMessage()];
        }
    }




    public function getReactionsCount($mode_id, $mode = 'comment')
    {
        try {
            $mode_id = intval($mode_id);
            $mode = trim(strtolower($mode));

            $sql = "SELECT 
                    reaction_type, 
                    COUNT(*) as total 
                FROM mode_reactions 
                WHERE mode_id = :mode_id AND mode = :mode
                GROUP BY reaction_type";

            $stmt = $this->mDb->connect()->prepare($sql);
            $stmt->execute([
                ':mode_id' => $mode_id,
                ':mode' => $mode
            ]);

            $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

            $result = ['like' => 0, 'dislike' => 0];
            foreach ($rows as $row) {
                $type = $row['reaction_type'];
                $result[$type] = intval($row['total']);
            }

            return ['status' => 200, 'data' => $result];
        } catch (PDOException $e) {
            return ['status' => 500, 'message' => 'Database Error: ' . $e->getMessage()];
        }
    }

    public function getUserReactionForComment($comment_id, $user_id)
    {
        try {
            $stmt = $this->mDb->connect()->prepare(
                "SELECT reaction_type FROM comment_reactions 
            WHERE comment_id = ? AND user_id = ?"
            );
            $stmt->execute([$comment_id, $user_id]);
            $reaction = $stmt->fetchColumn();

            if ($reaction) {
                return ['status' => 200, 'reaction_type' => $reaction];
            } else {
                return ['status' => 204, 'reaction_type' => null];
            }
        } catch (PDOException $e) {
            return ['status' => 500, 'message' => 'Database Error: ' . $e->getMessage()];
        }
    }
}
