<?php

$pagesObj = new pages();

class pages
{

	var $mDb;
	var $mConfig;
	var $mlang;
    

	function __construct()
	{
		global $Config;
		global $Lang;
		$this->mDb = new iplus();
		$this->mConfig = $Config;
		$this->mlang = $Lang;
     
	}


	function convert_object_to_array($data)
	{

		if (is_object($data)) {
			$data = get_object_vars($data);
		}

		if (is_array($data)) {
			return array_map(__METHOD__, $data);
		} else {
			return $data;
		}
	}
    function getAllPages($aStart, $aLimit, $sort, $type, $searchTitle) {
        $lang_code = LANGUAGE;
        
        $sql = "SELECT p.id, p.added_by, p.status, p.date_added, pl.description, pl.title, p.img
                FROM pages p
                LEFT JOIN pages_langs pl ON p.id = pl.page_id AND pl.lang_code = :lang_code
                WHERE p.id > 0 ";
    
        if ($searchTitle) {
            $sql .= " AND pl.title LIKE :searchTitle";
        }
        if ($sort == 'title') {
            $sql .= " ORDER BY pl.title {$type}";
        } else {
            $sql .= " ORDER BY p.{$sort} {$type}";
        }
        if ($aLimit) {
            $sql .= " LIMIT :aStart, :aLimit";
        }
    
        try {
            $this->mDb->connect()->beginTransaction();  // Start transaction
    
            $stmt = $this->mDb->connect()->prepare($sql);
            $stmt->bindParam(':lang_code', $lang_code, PDO::PARAM_STR);
    
            if ($searchTitle) {
                $stmt->bindParam(':searchTitle', $searchTitle, PDO::PARAM_STR);
            }
    
            if ($aLimit) {
                $stmt->bindParam(':aStart', $aStart, PDO::PARAM_INT);
                $stmt->bindParam(':aLimit', $aLimit, PDO::PARAM_INT);
            }
    
            $stmt->execute();
            $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
            $this->mDb->connect()->commit();  // Commit transaction
            return $results;
    
        } catch (PDOException $e) {
            $this->mDb->connect()->rollBack();  // Rollback transaction on error
            error_log("PDOException in getAllPages: " . $e->getMessage());
            return array();
        }
    }
    
    function getSearchPagesCount($searchTitle) {
        $lang_code = LANGUAGE;
        $sql = "SELECT COUNT(p.`id`) as result_count 
                FROM pages p
                LEFT JOIN pages_langs pl ON p.id = pl.page_id AND pl.lang_code = :lang_code
                WHERE p.`id` > 0 ";
    
        if (!empty($searchTitle)) {
            $sql .= " AND pl.title LIKE :searchTitle";
        }
    
        try {
            $this->mDb->connect()->beginTransaction();  // Start transaction
    
            $stmt = $this->mDb->connect()->prepare($sql);
            $stmt->bindParam(':lang_code', $lang_code, PDO::PARAM_STR);
    
            if (!empty($searchTitle)) {
                $stmt->bindParam(':searchTitle', $searchTitle, PDO::PARAM_STR);
            }
    
            $stmt->execute();
            $resultCount = $stmt->fetchColumn();
    
            $this->mDb->connect()->commit();  // Commit transaction
            return $resultCount;
    
        } catch (PDOException $e) {
            $this->mDb->connect()->rollBack();  // Rollback transaction on error
            error_log("PDOException in getSearchPagesCount: " . $e->getMessage());
            return 0;
        }
    }
    function getOnePage($id) {
        try {
            $lang_code = LANGUAGE;
    
            $sql = "SELECT 
                        p.id, 
                        p.added_by, 
                        p.status, 
                        p.date_added, 
                        p.img, 
                        pl.title, 
                        pl.description
                    FROM 
                        pages p
                    LEFT JOIN 
                        pages_langs pl ON p.id = pl.page_id AND pl.lang_code = :lang_code
                    WHERE 
                        p.id = :id";
    
            $stmt = $this->mDb->connect()->prepare($sql);
            $stmt->bindParam(':id', $id, PDO::PARAM_INT);
            $stmt->bindParam(':lang_code', $lang_code, PDO::PARAM_STR);
    
            if ($stmt->execute()) {
                $result = $stmt->fetch(PDO::FETCH_ASSOC);
    
                if (!$result) {
                    return ["status" => 404, "message" => "Page with ID $id not found."];
                }
            }
    
            return $result;
    
        } catch (Exception $e) {
            return [
                "status" => 500,
                "message" => "An error occurred: " . $e->getMessage()
            ];
        }
    }
    

}