<?php

$commentsObj = new comments();

class comments
{

    var $mDb;
    var $mConfig;
    var $mlang;


    function __construct()
    {
        global $Config;
        global $Lang;
        $this->mDb = new iplus();
        $this->mConfig = $Config;
        $this->mlang = $Lang;
    }

    function convert_object_to_array($data)
    {

        if (is_object($data)) {
            $data = get_object_vars($data);
        }

        if (is_array($data)) {
            return array_map(__METHOD__, $data);
        } else {
            return $data;
        }
    }


    function addEditComment($data)
    {
        try {
            $db = $this->mDb->connect();
            $db->beginTransaction();

            $id_comment  = isset($data['id']) ? intval($data['id']) : 0;
            $id_article  = isset($data['id_article']) ? intval($data['id_article']) : 0;
            $id_user     = isset($data['id_user']) ? intval($data['id_user']) : 0;
            $content     = isset($data['content']) ? trim($data['content']) : '';
            $parent_id   = isset($data['parent_id']) ? intval($data['parent_id']) : null;

            if (empty($content)) {
                return ['status' => 400, 'message' => 'لا يمكن ترك محتوى التعليق فارغًا'];
            }

            if ($id_comment > 0) {
                // ✅ تعديل تعليق
                $stmt = $db->prepare("SELECT COUNT(*) FROM comments WHERE id = ?");
                $stmt->execute([$id_comment]);
                if ($stmt->fetchColumn() == 0) {
                    return ['status' => 404, 'message' => 'لم يتم العثور على التعليق'];
                }

                $stmt = $db->prepare("UPDATE comments SET content = :content WHERE id = :id");
                $stmt->execute([
                    ':content' => $content,
                    ':id' => $id_comment
                ]);

                $message = 'تم تعديل التعليق بنجاح';
            } else {
                // ✅ إضافة تعليق جديد
                if (!$id_article || !$id_user) {
                    return ['status' => 400, 'message' => 'رقم المقال أو المستخدم غير صالح'];
                }

                $stmt = $db->prepare("INSERT INTO comments (id_article, id_user, content, parent_id, date_added, status)
                VALUES (:id_article, :id_user, :content, :parent_id, NOW(), 'active')
            ");
                $stmt->execute([
                    ':id_article' => $id_article,
                    ':id_user' => $id_user,
                    ':content' => $content,
                    ':parent_id' => $parent_id
                ]);

                $id_comment = $db->lastInsertId();
                $message = 'تم إضافة التعليق بنجاح';
            }

            $db->commit();

            return [
                'status' => 200,
                'message' => $message,
                'id_comment' => $id_comment
            ];
        } catch (PDOException $e) {
            if ($db->inTransaction()) $db->rollBack();
            return ['status' => 500, 'message' => 'Database Error: ' . $e->getMessage()];
        }
    }

public function getCommentsWithReplies($id_article, $aStart = 0, $aLimit = 10, $id_user, $parent_id = null)
{
    try {
        $id_article = intval($id_article);
        $id_user = intval($id_user);
        $aStart = max(0, intval($aStart));
        $aLimit = max(1, intval($aLimit));

        if ($id_article <= 0 || $id_user <= 0) {
            return [];
        }

        $db = $this->mDb->connect();

        // ✅ بناء الاستعلام بناءً على قيمة parent_id
        if ($parent_id === null) {
            // تعليقات رئيسية
            $sql = "SELECT c.id, c.id_user, c.content, c.parent_id, c.date_added, u.full_name AS user_name, u.img
                    FROM comments c
                    LEFT JOIN users u ON u.id = c.id_user
                    WHERE c.parent_id IS NULL AND c.id_article = :id_article AND c.status = 'active'
                    ORDER BY c.date_added ASC
                    LIMIT :aStart, :aLimit";
            $stmt = $db->prepare($sql);
            $stmt->bindValue(':id_article', $id_article, PDO::PARAM_INT);
            $stmt->bindValue(':aStart', $aStart, PDO::PARAM_INT);
            $stmt->bindValue(':aLimit', $aLimit, PDO::PARAM_INT);
        } else {
            // ردود على تعليق
            $sql = "SELECT c.id, c.id_user, c.content, c.parent_id, c.date_added, u.full_name AS user_name, u.img
                    FROM comments c
                    LEFT JOIN users u ON u.id = c.id_user
                    WHERE c.parent_id = :parent_id AND c.id_article = :id_article AND c.status = 'active'
                    ORDER BY c.date_added ASC
                    LIMIT :aStart, :aLimit";
            $stmt = $db->prepare($sql);
            $stmt->bindValue(':parent_id', $parent_id, PDO::PARAM_INT);
            $stmt->bindValue(':id_article', $id_article, PDO::PARAM_INT);
            $stmt->bindValue(':aStart', $aStart, PDO::PARAM_INT);
            $stmt->bindValue(':aLimit', $aLimit, PDO::PARAM_INT);
        }

        $stmt->execute();
        $comments = $stmt->fetchAll(PDO::FETCH_ASSOC);
        // print_r($comments); // Debugging line, can be removed later

        if (!$comments) return []; // مفيش تعليقات

        // ✅ تجهيز استعلامات reuse
        $stmtReply = $db->prepare("SELECT c.id, c.id_user, c.content, c.parent_id, c.date_added, u.full_name AS user_name, u.img
                                   FROM comments c
                                   LEFT JOIN users u ON u.id = c.id_user
                                   WHERE c.parent_id = :parent_id AND c.status = 'active'
                                   ORDER BY c.date_added ASC");

        $stmtReact = $db->prepare("SELECT reaction_type FROM mode_reactions WHERE user_id = :user_id AND mode_id = :mode_id AND mode = 'comment'");

        $stmtCount = $db->prepare("SELECT reaction_type, COUNT(*) as count FROM mode_reactions WHERE mode_id = :mode_id AND mode='comment' GROUP BY reaction_type");

        foreach ($comments as &$comment) {
            $comment_id = $comment['id'];

            // التفاعل على التعليق الأساسي
            $stmtReact->execute([':user_id' => $id_user, ':mode_id' => $comment_id]);
            $reaction = $stmtReact->fetch(PDO::FETCH_ASSOC);
            $comment['user_reaction'] = $reaction ? $reaction['reaction_type'] : null;

            // العدادات
            $stmtCount->execute([':mode_id' => $comment_id]);
            $counts = $stmtCount->fetchAll(PDO::FETCH_KEY_PAIR);
            $comment['likes'] = isset($counts['like']) ? intval($counts['like']) : 0;
            $comment['dislikes'] = isset($counts['dislike']) ? intval($counts['dislike']) : 0;

            // الردود
            $stmtReply->execute([':parent_id' => $comment_id]);
            $replies = $stmtReply->fetchAll(PDO::FETCH_ASSOC);
           

            foreach ($replies as &$reply) {
                $reply_id = $reply['id'];

                $stmtReact->execute([':user_id' => $id_user, ':mode_id' => $reply_id]);
                $reaction = $stmtReact->fetch(PDO::FETCH_ASSOC);
                $reply['user_reaction'] = $reaction ? $reaction['reaction_type'] : null;

                $stmtCount->execute([':mode_id' => $reply_id]);
                $counts = $stmtCount->fetchAll(PDO::FETCH_KEY_PAIR);
                $reply['likes'] = isset($counts['like']) ? intval($counts['like']) : 0;
                $reply['dislikes'] = isset($counts['dislike']) ? intval($counts['dislike']) : 0;
            }

            $comment['replies'] = $replies;
            }

        return $comments;

    } catch (Exception $e) {
        return [
            'status' => 500,
            'message' => 'حدث خطأ أثناء جلب التعليقات: ' . $e->getMessage()
        ];
    }
}






    public function deleteComments($ids)
    {
        $deleted = 0;
        $this->mDb->connect()->beginTransaction();

        try {
            $sqlDelete = "DELETE FROM comments WHERE id = :id";

            foreach ($ids as $id) {
                $id = intval($id);
                if ($id <= 0) continue;

                $stmtCheck = $this->mDb->connect()->prepare("SELECT id FROM comments WHERE id = :id");
                $stmtCheck->bindParam(':id', $id, PDO::PARAM_INT);
                $stmtCheck->execute();

                if ($stmtCheck->fetch()) {
                    $stmtDelete = $this->mDb->connect()->prepare($sqlDelete);
                    $stmtDelete->bindParam(':id', $id, PDO::PARAM_INT);
                    $stmtDelete->execute();

                    if ($stmtDelete->rowCount() > 0) {
                        $deleted++;
                    }
                }
            }

            if ($deleted === 0) {
                $this->mDb->connect()->rollBack();
                return [
                    "status" => 404,
                    "message" => "لم يتم حذف أي تعليق"
                ];
            }

            $this->mDb->connect()->commit();
            return [
                "status" => 200,
                "message" => "comments deleted successfully",
                "deleted_count" => $deleted
            ];
        } catch (PDOException $e) {
            $this->mDb->connect()->rollBack();
            return [
                "status" => 500,
                "message" => "حدث خطأ أثناء الحذف: " . $e->getMessage()
            ];
        }
    }
}
