<?php
$categoriesObj = new categories();

class categories{

var $mDb;
var $mConfig;
var $mlang;


function __construct(){
    global $Config;
    global $lang;
    $this->mDb = new iplus();
    $this->mConfig= $Config;
    $this->mlang= $lang;
}

function convert_object_to_array($data){
    if(is_object($data)){
        $data=get_object_vars($data);
    }
    if(is_array($data)){
        return(array_map(__METHOD__,$data))   ;     
    }else{
                return $data;
            }
}

    function getAllCategoriesWithLangs($lang_code = 'ar')
{
    try {
        $sql = "SELECT 
                c.id,
                c.image,
                c.parent_id,
                c.sort,
                cl.name,
                cl.lang_code
            FROM categories c
            LEFT JOIN categories_langs cl ON cl.id_cat = c.id AND cl.lang_code = :lang_code
            ORDER BY c.parent_id ASC, c.id ASC";

        $stmt = $this->mDb->connect()->prepare($sql);
        $stmt->bindParam(':lang_code', $lang_code, PDO::PARAM_STR);
        $stmt->execute();

        $result = $stmt->fetchAll(PDO::FETCH_OBJ);
        return $this->convert_object_to_array($result);

    } catch (PDOException $e) {
        return ['status' => 500, 'message' => 'Database Error: ' . $e->getMessage()];
    }
}

//     function getCategoryTree($parentId,$lang_code = 'ar')
// {
//     try {
//         $sql = "SELECT 
//                 c.id,
//                 c.parent_id,
//                 c.sort,
//                 c.image,
//                 cl.name
//             FROM categories c
//             LEFT JOIN categories_langs cl 
//                 ON cl.id_cat = c.id AND cl.lang_code = :lang_code
//                 WHERE c.parent_id = :parentId
//             ORDER BY c.sort ASC, c.id ASC
//         ";

//         $stmt = $this->mDb->connect()->prepare($sql);
//         $stmt->bindParam(':lang_code', $lang_code, PDO::PARAM_STR);
//         $stmt->bindParam(':parentId', $parentId, PDO::PARAM_INT);

//         $stmt->execute();
//         $categories = $stmt->fetchAll(PDO::FETCH_ASSOC);

//         $tree = [];
//         $map = [];

//         foreach ($categories as &$cat) {
//             $cat['children'] = [];
//             $map[$cat['id']] = &$cat;
//         }

//         foreach ($categories as &$cat) {
//             if ($cat['parent_id'] == 0) {
//                 $tree[] = &$cat;
//             } else {
//                 if (isset($map[$cat['parent_id']])) {
//                     $map[$cat['parent_id']]['children'][] = &$cat;
//                 }
//             }
//         }

//         return $tree;

//     } catch (PDOException $e) {
//         return ['status' => 500, 'message' => 'Database Error: ' . $e->getMessage()];
//     }
// }


function getCategoryTree($parentId = 0, $lang_code = 'ar') {
    try {
        $db = $this->mDb->connect();

        // دالة recursive داخلية لجلب الأبناء
        $fetchChildren = function($parentId) use (&$fetchChildren, $db, $lang_code) {
            $sql = "SELECT 
                    c.id,
                    c.parent_id,
                    c.sort,
                    c.image,
                    cl.name
                FROM categories c
                LEFT JOIN categories_langs cl  ON cl.id_category = c.id AND cl.lang_code = :lang_code
                WHERE c.parent_id = :parentId
                ORDER BY c.sort ASC, c.id ASC
            ";
            $stmt = $db->prepare($sql);
            $stmt->bindParam(':lang_code', $lang_code);
            $stmt->bindParam(':parentId', $parentId, PDO::PARAM_INT);
            $stmt->execute();
            $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

            foreach ($rows as &$row) {
                $children = $fetchChildren($row['id']);
                $row['has_children'] = !empty($children);
                $row['children'] = $children;
            }

            return $rows;
        };

        $tree = $fetchChildren($parentId);

        return [
            'success' => true,
            'data' => $tree
        ];

    } catch (PDOException $e) {
        return [
            'success' => false,
            'message' => 'Database Error: ' . $e->getMessage()
        ];
    }
}


function getCategoryByParentId($parentId =0, $lang_code = 'ar') {
    try {
        $sql = "SELECT 
                    c.id,
                    c.parent_id,
                    c.sort,
                    c.image,
                    cl.name
                FROM categories c
                LEFT JOIN categories_langs cl 
                    ON cl.id_category = c.id AND cl.lang_code = :lang_code
                WHERE c.parent_id = :parentId
                ORDER BY c.sort ASC, c.id ASC";

        $stmt = $this->mDb->connect()->prepare($sql);
        $stmt->bindParam(':lang_code', $lang_code, PDO::PARAM_STR);
        $stmt->bindParam(':parentId', $parentId, PDO::PARAM_INT);
        $stmt->execute();
        $categories = $stmt->fetchAll(PDO::FETCH_ASSOC);

        foreach ($categories as &$category) {
            // تحقق هل لهذا القسم أبناء
            $subSql = "SELECT COUNT(*) FROM categories WHERE parent_id = :id";
            $subStmt = $this->mDb->connect()->prepare($subSql);
            $subStmt->bindParam(':id', $category['id'], PDO::PARAM_INT);
            $subStmt->execute();
            $hasChildren = $subStmt->fetchColumn() > 0;

            $category['has_children'] = $hasChildren;
        }

        return $categories;

    } catch (PDOException $e) {
        return ['status' => 500, 'message' => 'Database Error: ' . $e->getMessage()];
    }
}


}









?>