<?php

$banksBranchesObj = new bankBranches();

class bankBranches
{

	var $mDb;
	var $mConfig;
	var $mlang;
    

	function __construct()
	{
		global $Config;
		global $Lang;
		$this->mDb = new iplus();
		$this->mConfig = $Config;
		$this->mlang = $Lang;
     
	}

	function convert_object_to_array($data)
	{

		if (is_object($data)) {
			$data = get_object_vars($data);
		}

		if (is_array($data)) {
			return array_map(__METHOD__, $data);
		} else {
			return $data;
		}
	}

    function getBankBranches($bankId, $latitude, $longitude) {
        try {
            $lang_code = LANGUAGE; // Get the language code
    
            // Fetch all ATMs for the given bank ID that are not deleted, including distance calculation
            $sql = "SELECT b.*, 
                           bl.address, bl.name,
                           (6371 * ACOS(COS(RADIANS(:latitude)) * COS(RADIANS(b.latitude)) * 
                           COS(RADIANS(b.longitude) - RADIANS(:longitude)) + 
                           SIN(RADIANS(:latitude)) * SIN(RADIANS(b.latitude)))) AS distance
                    FROM branches b
                    LEFT JOIN branches_langs bl ON b.id = bl.branch_id AND bl.lang_code = :lang_code
                    WHERE b.bank_id = :bank_id AND b.is_deleted = 0
                    HAVING distance <= 50
                    ORDER BY distance ASC";
    
            $stmt = $this->mDb->connect()->prepare($sql);
            $stmt->bindParam(':bank_id', $bankId, PDO::PARAM_INT);
            $stmt->bindParam(':latitude', $latitude, PDO::PARAM_STR);
            $stmt->bindParam(':longitude', $longitude, PDO::PARAM_STR);
            $stmt->bindParam(':lang_code', $lang_code, PDO::PARAM_STR);
    
            if ($stmt->execute()) {
                $branches = $stmt->fetchAll(PDO::FETCH_ASSOC);
                // print_r($branches);die;
    
                if (!$branches) {
                    return ["status" => 404, "message" => "No BRANCHES found near the provided location for bank ID $bankId."];
                }
            } else {
                throw new Exception("Error executing the SQL statement: " . implode(", ", $stmt->errorInfo()));
            }
    
            // Return the formatted response
            return $branches;
                
        } catch (Exception $e) {
            return [
                "status" => 500,
                "message" => "An error occurred: " . $e->getMessage()
            ];
        }
    }





}