<?php

$bannersObj = new banners();

class banners
{

	var $mDb;
	var $mConfig;
	var $mlang;
    

	function __construct()
	{
		global $Config;
		global $Lang;
		$this->mDb = new iplus();
		$this->mConfig = $Config;
		$this->mlang = $Lang;
     
	}

	function convert_object_to_array($data)
	{

		if (is_object($data)) {
			$data = get_object_vars($data);
		}

		if (is_array($data)) {
			return array_map(__METHOD__, $data);
		} else {
			return $data;
		}
	}
    function getAllBannersByType($type) {
        $lang_code = LANGUAGE;
    
        $sql = "SELECT b.*, bl.name, bl.description
                FROM bank_banners bb
                INNER JOIN banners b ON bb.banner_id = b.id AND b.is_deleted = 0
                LEFT JOIN banners_langs bl ON b.id = bl.banner_id AND bl.lang_code = :lang_code
                WHERE bb.place = :type AND b.is_deleted = 0";
    
        try {
            $stmt = $this->mDb->connect()->prepare($sql);
            $stmt->bindParam(':lang_code', $lang_code, PDO::PARAM_STR);
            $stmt->bindParam(':type', $type, PDO::PARAM_STR);
            $stmt->execute();
    
            return $stmt->fetchAll(PDO::FETCH_ASSOC);
        } catch (PDOException $e) {
            error_log("PDOException in getAllBannersByType: " . $e->getMessage());
            return [];
        }
    }
    function getAllBannersByBankId($bank_id) {
        $lang_code = LANGUAGE;
    
        $sql = "SELECT b.*, bl.name, bl.description
                FROM bank_banners bb
                INNER JOIN banners b ON bb.banner_id = b.id AND b.is_deleted = 0
                LEFT JOIN banners_langs bl ON b.id = bl.banner_id AND bl.lang_code = :lang_code
                WHERE bb.bank_id = :bank_id AND b.is_deleted = 0";
    
        try {
            $stmt = $this->mDb->connect()->prepare($sql);
            $stmt->bindParam(':lang_code', $lang_code, PDO::PARAM_STR);
            $stmt->bindParam(':bank_id', $bank_id, PDO::PARAM_INT);
            $stmt->execute();
    
            return $stmt->fetchAll(PDO::FETCH_ASSOC);
        } catch (PDOException $e) {
            error_log("PDOException in getAllBannersByBankId: " . $e->getMessage());
            return [];
        }
    }
    
    
    
    
}