<?php

$banksObj = new banks();

class banks
{

	var $mDb;
	var $mConfig;
	var $mlang;
    

	function __construct()
	{
		global $Config;
		global $Lang;
		$this->mDb = new iplus();
		$this->mConfig = $Config;
		$this->mlang = $Lang;
     
	}

	function convert_object_to_array($data)
	{

		if (is_object($data)) {
			$data = get_object_vars($data);
		}

		if (is_array($data)) {
			return array_map(__METHOD__, $data);
		} else {
			return $data;
		}
	}
   
    function getAllBanks($aStart, $aLimit, $sort, $type, $searchName) {
        $lang_code = LANGUAGE;
        $sql = "SELECT b.id, b.added_by, b.status, b.sort, b.logo, b.date_added, bl.name
                FROM banks b
                LEFT JOIN banks_langs bl ON b.id = bl.bank_id AND bl.lang_code = :lang_code
                WHERE b.is_deleted = 0 ";
    
        if ($searchName) {
            $sql .= " AND bl.name LIKE :searchName";
        }
        if ($sort == 'name') {
            $sql .= " ORDER BY bl.name {$type}";
        } else {
            $sql .= " ORDER BY b.{$sort} {$type}";
        }
        if ($aLimit) {
            $sql .= " LIMIT :aStart, :aLimit";
        }
        // echo ($sql);die();
        try {
            $this->mDb->connect()->beginTransaction();
    
            $stmt = $this->mDb->connect()->prepare($sql);
            $stmt->bindParam(':lang_code', $lang_code, PDO::PARAM_STR);
    
            if ($searchName) {
                $stmt->bindParam(':searchName', $searchName, PDO::PARAM_STR);
            }
    
            if ($aLimit) {
                $stmt->bindParam(':aStart', $aStart, PDO::PARAM_INT);
                $stmt->bindParam(':aLimit', $aLimit, PDO::PARAM_INT);
            }
    
            $stmt->execute();
            $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
            $this->mDb->connect()->commit();
            return $results;
    
        } catch (PDOException $e) {
            $this->mDb->connect()->rollBack();
            error_log("PDOException in getAllPages: " . $e->getMessage());
            return array();
        }
    }
    function getOneBank($id) {
        try {
            $lang_code = LANGUAGE; 
    
            $sql = "SELECT b.id, b.added_by, b.status, b.sort, b.date_added, b.logo, 
                           bl.name 
                    FROM banks b
                    LEFT JOIN banks_langs bl ON b.id = bl.bank_id AND bl.lang_code = :lang_code
                    WHERE b.id = :id";
    
            $stmt = $this->mDb->connect()->prepare($sql);
            $stmt->bindParam(':id', $id, PDO::PARAM_INT);
            $stmt->bindParam(':lang_code', $lang_code, PDO::PARAM_STR);
    
            if ($stmt->execute()) {
                $result = $stmt->fetch(PDO::FETCH_ASSOC);
                if (!$result) {
                    return ["status" => 404, "message" => "Bank with ID $id not found."];
                }
            } else {
                throw new Exception("Error executing the SQL statement: " . implode(", ", $stmt->errorInfo()));
            }
            return $result;
                
           
        } catch (Exception $e) {
            return [
                "status" => 500,
                "message" => "An error occurred: " . $e->getMessage()
            ];
        }
    }
    
}