<?php

$atmsObj = new atms();

class atms
{

	var $mDb;
	var $mConfig;
	var $mlang;
    

	function __construct()
	{
		global $Config;
		global $Lang;
		$this->mDb = new iplus();
		$this->mConfig = $Config;
		$this->mlang = $Lang;
     
	}

	function convert_object_to_array($data)
	{

		if (is_object($data)) {
			$data = get_object_vars($data);
		}

		if (is_array($data)) {
			return array_map(__METHOD__, $data);
		} else {
			return $data;
		}
	}
    function getAllAtms($aStart, $aLimit, $sort, $type, $searchaddress, $searchBankId) {
        $lang_code = LANGUAGE;
        
        // Validate if the searchBankId exists in the branches table
        if ($searchBankId) {
            $validationSql = "SELECT COUNT(*) AS count FROM atms WHERE bank_id = :searchBankId AND is_deleted = 0";
            try {
                $validationStmt = $this->mDb->connect()->prepare($validationSql);
                $validationStmt->bindParam(':searchBankId', $searchBankId, PDO::PARAM_INT);
                $validationStmt->execute();
                $validationResult = $validationStmt->fetch(PDO::FETCH_ASSOC);
    
                if ($validationResult['count'] == 0) {
                    return ['error' => "Bank ID {$searchBankId} does not exist in the atms table."];
                }
            } catch (PDOException $e) {
                error_log("PDOException in validating searchBankId: " . $e->getMessage());
                return ['error' => "An error occurred while validating the Bank ID."];
            }
        }
    
        // Main query
        $sql = "SELECT a.*, al.address
                FROM atms a
                LEFT JOIN atms_langs al ON a.id = al.atm_id AND al.lang_code = :lang_code
                WHERE a.is_deleted = 0 ";
    
        if ($searchaddress) {
            $sql .= " AND al.address LIKE :searchaddress";
        }
        if ($searchBankId) {
            $sql .= " AND a.bank_id = :searchBankId";
        }
        if ($sort == 'address') {
            $sql .= " ORDER BY al.address {$type}";
        } else {
            $sql .= " ORDER BY a.{$sort} {$type}";
        }
        if ($aLimit) {
            $sql .= " LIMIT :aStart, :aLimit";
        }
        // echo ($sql);die();
        try {
            $this->mDb->connect()->beginTransaction();
    
            $stmt = $this->mDb->connect()->prepare($sql);
            $stmt->bindParam(':lang_code', $lang_code, PDO::PARAM_STR);
    
            if ($searchaddress) {
                $stmt->bindParam(':searchaddress', $searchaddress, PDO::PARAM_STR);
            }
            if ($searchBankId) {
                $stmt->bindParam(':searchBankId', $searchBankId, PDO::PARAM_INT);
            }
    
            if ($aLimit) {
                $stmt->bindParam(':aStart', $aStart, PDO::PARAM_INT);
                $stmt->bindParam(':aLimit', $aLimit, PDO::PARAM_INT);
            }
    
            $stmt->execute();
            $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
            $this->mDb->connect()->commit();
            return $results;
    
        } catch (PDOException $e) {
            $this->mDb->connect()->rollBack();
            error_log("PDOException in getAllPages: " . $e->getMessage());
            return array();
        }
    }
    function getBankAtms($bankId, $latitude, $longitude) {
        try {
            $lang_code = LANGUAGE; // Get the language code
    
            // Fetch all ATMs for the given bank ID that are not deleted, including distance calculation
            $sql = "SELECT a.id, a.bank_id, a.latitude, a.longitude, a.is_deleted, 
                           al.address,
                           (6371 * ACOS(COS(RADIANS(:latitude)) * COS(RADIANS(a.latitude)) * 
                           COS(RADIANS(a.longitude) - RADIANS(:longitude)) + 
                           SIN(RADIANS(:latitude)) * SIN(RADIANS(a.latitude)))) AS distance
                    FROM atms a
                    LEFT JOIN atms_langs al ON a.id = al.atm_id AND al.lang_code = :lang_code
                    WHERE a.bank_id = :bank_id AND a.is_deleted = 0
                    HAVING distance <= 50
                    ORDER BY distance ASC";
    
            $stmt = $this->mDb->connect()->prepare($sql);
            $stmt->bindParam(':bank_id', $bankId, PDO::PARAM_INT);
            $stmt->bindParam(':latitude', $latitude, PDO::PARAM_STR);
            $stmt->bindParam(':longitude', $longitude, PDO::PARAM_STR);
            $stmt->bindParam(':lang_code', $lang_code, PDO::PARAM_STR);
    
            if ($stmt->execute()) {
                $atms = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
                if (!$atms) {
                    return ["status" => 404, "message" => "No ATMs found near the provided location for bank ID $bankId."];
                }
            } else {
                throw new Exception("Error executing the SQL statement: " . implode(", ", $stmt->errorInfo()));
            }
    
            // Return the formatted response
            return $atms;
                
        } catch (Exception $e) {
            return [
                "status" => 500,
                "message" => "An error occurred: " . $e->getMessage()
            ];
        }
    }
    
}