<?php
$articlesObj = new articles();

class articles
{

    var $mDb;
    var $mConfig;
    var $mlang;

    function __construct()
    {
        global $Config;
        global $lang;
        $this->mDb = new iplus();
        $this->mConfig = $Config;
        $this->mlang = $lang;
    }

    function convert_object_to_array($data)
    {
        if (is_object($data)) {
            $data = get_object_vars($data);
        }
        if (is_array($data)) {
            return (array_map(__METHOD__, $data));
        } else {
            return $data;
        }
    }




    // function getArticlesByCategoryId($category_id, $lang_code = 'ar', $aStart = 0, $aLimit = 100, $type = 'DESC', $article_id = null)
    // {
    //     try {
    //         $category_id = intval($category_id);
    //         if ($category_id <= 0) {
    //             return ['status' => 400, 'message' => 'Invalid category ID'];
    //         }

    //         $type = strtoupper($type);
    //         if (!in_array($type, ['ASC', 'DESC'])) {
    //             $type = 'DESC';
    //         }

    //         $sql = "SELECT 
    //                     a.id,
    //                     a.id_cat,
    //                     a.status,
    //                     a.image,
    //                     a.sort,
    //                     a.views,
    //                     a.date_added,
    //                     al.title,
    //                     al.content
    //                 FROM articles a
    //                 LEFT JOIN articles_langs al ON al.id_article = a.id AND al.lang_code = :lang_code
    //                 WHERE a.id_cat = :category_id AND a.status = 'active' ";

    //         if (!is_null($article_id)) {
    //             $sql .= " AND a.id = :article_id";
    //         }

    //         $sql .= " ORDER BY a.sort {$type}, a.id {$type} LIMIT :aStart, :aLimit";

    //         $db = $this->mDb->connect();
    //         $stmt = $db->prepare($sql);

    //         $stmt->bindValue(':category_id', $category_id, PDO::PARAM_INT);
    //         $stmt->bindValue(':lang_code', $lang_code, PDO::PARAM_STR);
    //         $stmt->bindValue(':aStart', $aStart, PDO::PARAM_INT);
    //         $stmt->bindValue(':aLimit', $aLimit, PDO::PARAM_INT);

    //         if (!is_null($article_id)) {
    //             $stmt->bindValue(':article_id', intval($article_id), PDO::PARAM_INT);
    //         }

    //         $stmt->execute();
    //         $result = $stmt->fetchAll(PDO::FETCH_OBJ);

    //         return $this->convert_object_to_array($result);

    //     } catch (PDOException $e) {
    //         return ['status' => 500, 'message' => 'Database Error: ' . $e->getMessage()];
    //     }
    // }



    function buildArticlePathFromArticleId($category_id, $lang_code = 'ar')
    {
        $db = $this->mDb->connect();
        $path = [];

        while ($category_id != 0) {
            $stmt = $db->prepare("
            SELECT c.id, c.parent_id, cl.name
            FROM categories c
            LEFT JOIN categories_langs cl ON cl.id_cat = c.id AND cl.lang_code = :lang_code
            WHERE c.id = :id
            LIMIT 1
        ");
            $stmt->execute([
                ':id' => $category_id,
                ':lang_code' => $lang_code
            ]);
            $row = $stmt->fetch(PDO::FETCH_ASSOC);

            if (!$row || !$row['name']) break;

            $path[] = $row['name'];
            $category_id = $row['parent_id'];
        }

        return implode(' > ', array_reverse($path));
    }
    function getOneArticle($article_id, $lang_code = 'ar', $aStart = 0, $aLimit = 10, $id_user = 0)
    {
        try {
            $id = intval($article_id);
            $id_user = intval($id_user);
            if ($id <= 0) {
                return ['status' => 400, 'message' => 'Invalid article ID'];
            }


            $lang_code = !empty($lang_code) ? $lang_code : 'ar';
            $aStart = max(0, intval($aStart));
            $aLimit = max(1, intval($aLimit));

            $db = $this->mDb->connect();

            // 🟢 جلب بيانات المقال
            $sql = "SELECT 
                    a.id,
                    a.image,
                    a.views,
                    a.date_added,
                    al.title,
                    al.content
                FROM articles a
                LEFT JOIN articles_langs al ON al.id_article = a.id AND al.lang_code = :lang_code
                WHERE a.id = :id
                LIMIT 1";

            $stmt = $db->prepare($sql);
            $stmt->execute([
                ':id' => $article_id,
                ':lang_code' => $lang_code

            ]);

            $article = $stmt->fetch(PDO::FETCH_ASSOC);

            if (!$article) {
                return ['status' => 404, 'message' => 'Article not found'];
            }
            // ✅ تحضير استعلامات اللايك والديسلايك علي المقال 
            $stmtCount = $db->prepare("SELECT reaction_type, COUNT(*) as count FROM mode_reactions WHERE mode_id = :article_id AND mode='article' GROUP BY reaction_type ");
            $stmtReact = $db->prepare("SELECT reaction_type FROM mode_reactions WHERE user_id = :user_id AND mode_id = :article_id AND mode = 'article'");

            if ($id_user > 0) {
                $stmtReact->execute([':user_id' => $id_user, ':article_id' => $article_id]);
                $reaction = $stmtReact->fetch(PDO::FETCH_ASSOC);

                if ($reaction) {
                    $article['user_reaction_like'] = ($reaction['reaction_type'] === 'like') ? 1 : 0;
                    $article['user_reaction_dislike'] = ($reaction['reaction_type'] === 'dislike') ? 1 : 0;
                } else {
                    $article['user_reaction_like'] = 0;
                    $article['user_reaction_dislike'] = 0;
                }
            }
            $stmtCount->execute([':article_id' => $article_id]);
            $counts = $stmtCount->fetchAll(PDO::FETCH_KEY_PAIR);

            $article['likes'] = isset($counts['like']) ? intval($counts['like']) : 0;
            $article['dislikes'] = isset($counts['dislike']) ? intval($counts['dislike']) : 0;

            // ✅ تحديث عدد المشاهدات
            $updateViews = $db->prepare("UPDATE articles SET views = views + 1 WHERE id = :id");
            $updateViews->execute([':id' => $article_id]);

            // ✅ جلب التعليقات
            $stmtComments = $db->prepare("SELECT c.id, c.content, c.date_added, u.full_name AS user_name, u.img
            FROM comments c
            LEFT JOIN users u ON u.id = c.id_user
            WHERE c.id_article = :id_article AND c.status = 'active' 
            ORDER BY c.id ASC
            LIMIT :aStart, :aLimit");

            $stmtComments->bindParam(':id_article', $id, PDO::PARAM_INT);
            $stmtComments->bindParam(':aStart', $aStart, PDO::PARAM_INT);
            $stmtComments->bindParam(':aLimit', $aLimit, PDO::PARAM_INT);
            $stmtComments->execute();
            $comments = $stmtComments->fetchAll(PDO::FETCH_ASSOC);

            // ✅ تحضير استعلامات اللايك والديسلايك
            $stmtCount = $db->prepare("SELECT reaction_type, COUNT(*) as count FROM mode_reactions WHERE mode_id = :comment_id AND mode='comment' GROUP BY reaction_type ");
            $stmtReact = $db->prepare("SELECT reaction_type FROM mode_reactions WHERE user_id = :user_id AND mode_id = :comment_id AND mode = 'comment'");

            foreach ($comments as &$comment) {
                $comment_id = $comment['id'];

                if ($id_user > 0) {
                    $stmtReact->execute([':user_id' => $id_user, ':comment_id' => $comment_id]);
                    $reaction = $stmtReact->fetch(PDO::FETCH_ASSOC);

                    if ($reaction) {
                        $comment['user_reaction_like'] = ($reaction['reaction_type'] === 'like') ? 1 : 0;
                        $comment['user_reaction_dislike'] = ($reaction['reaction_type'] === 'dislike') ? 1 : 0;
                    } else {
                        $comment['user_reaction_like'] = 0;
                        $comment['user_reaction_dislike'] = 0;
                    }
                }else{
                    $comment['user_reaction_like'] = 0;
                    $comment['user_reaction_dislike'] = 0;
                }

                // ✅ التفاعل العام (الكل)
                $stmtCount->execute([':comment_id' => $comment_id]);
                $counts = $stmtCount->fetchAll(PDO::FETCH_KEY_PAIR);

                $comment['likes'] = isset($counts['like']) ? intval($counts['like']) : 0;
                $comment['dislikes'] = isset($counts['dislike']) ? intval($counts['dislike']) : 0;
            }

            $data = [
                'id'         => $article['id'],
                'image'      => $article['image'],
                'views'      => $article['views'],
                'date_added' => $article['date_added'],
                'title'      => $article['title'],
                'content'    => $article['content'],
                'user_reaction_like' => $article['user_reaction_like']??0,
                'user_reaction_dislike' => $article['user_reaction_dislike']??0,
                'likes'      => $article['likes'],
                'dislikes'   => $article['dislikes'],
                'comments'   => $comments

                
            ];


            return [
                'status' => 200,
                'data' => $data
            ];
        } catch (PDOException $e) {
            return [
                'status' => 500,
                'message' => 'Database Error: ' . $e->getMessage()
            ];
        }
    }





    function incrementArticleViews($article_id)
    {
        try {
            $article_id = intval($article_id);
            if ($article_id <= 0) {
                return ['status' => 400, 'message' => 'Invalid article ID'];
            }

            $db = $this->mDb->connect();

            // جلب عدد المشاهدات الحالي + التحقق من وجود المقال
            $sql = "SELECT views FROM articles WHERE id = :id LIMIT 1";
            $stmt = $db->prepare($sql);
            $stmt->execute([':id' => $article_id]);

            $article = $stmt->fetch(PDO::FETCH_ASSOC);

            if (!$article) {
                return ['status' => 404, 'message' => 'Article not found'];
            }

            // تحديث عدد المشاهدات
            $update = $db->prepare("UPDATE articles SET views = views + 1 WHERE id = :id");
            $update->execute([':id' => $article_id]);

            return [
                'status' => 200,
                'message' => 'View count updated successfully',
                'article_id' => $article_id,
                'views_before_update' => $article['views'],
                'views_after_update' => $article['views'] + 1
            ];
        } catch (PDOException $e) {
            return [
                'status' => 500,
                'message' => 'Database Error: ' . $e->getMessage()
            ];
        }
    }


    function buildArticlePath($article_id, $lang_code = 'ar')
    {
        $db = $this->mDb->connect();

        // ✅ التأكد من أن رقم المقال صحيح وموجود
        $stmt = $db->prepare("SELECT id_cat FROM articles WHERE id = :article_id LIMIT 1");
        $stmt->execute([':article_id' => $article_id]);
        $result = $stmt->fetch(PDO::FETCH_ASSOC);

        if (!$result || empty($result['id_cat'])) {
            return ['status' => 404, 'message' => 'Article not found'];
        }

        $category_id = $result['id_cat'];
        $path = [];

        // 🔁 بناء المسار من القسم إلى الأعلى
        while ($category_id != 0) {
            $stmt = $db->prepare("
            SELECT c.id, c.parent_id, cl.name
            FROM categories c
            LEFT JOIN categories_langs cl ON cl.id_cat = c.id AND cl.lang_code = :lang_code
            WHERE c.id = :id
            LIMIT 1
        ");
            $stmt->execute([
                ':id' => $category_id,
                ':lang_code' => $lang_code
            ]);
            $row = $stmt->fetch(PDO::FETCH_ASSOC);

            if (!$row || empty($row['name'])) break;

            $path[] = $row['name'];
            $category_id = $row['parent_id'];
        }

        return [
            'status' => 200,
            'path' => implode(' > ', array_reverse($path))
        ];
    }



    function getArticlesList($category_id, $lang_code = 'ar', $aStart = 0, $aLimit = 100, $type = 'DESC', $searchTitle = '')
    {
        try {
            $category_id = intval($category_id);
            if ($category_id <= 0) {
                return ['status' => 400, 'message' => 'Invalid category ID'];
            }

            $type = strtoupper($type);
            if (!in_array($type, ['ASC', 'DESC'])) {
                $type = 'DESC';
            }

            $sql = "SELECT 
                    a.id,
                    a.status,
                    ac.id_category,
                    a.image,
                    a.sort,
                    a.date_added,
                    al.title,
                    al.content
                FROM articles a
                LEFT JOIN articles_langs al ON al.id_article = a.id AND al.lang_code = :lang_code
                LEFT JOIN articles_categories ac ON ac.id_article = a.id
                WHERE ac.id_category = :category_id AND a.status = 1";

            // إذا فيه بحث بالاسم نضيفه للـ SQL
            if (!empty($searchTitle)) {
                $sql .= " AND al.title LIKE :searchTitle";
            }

            $sql .= " ORDER BY a.sort {$type}, a.id {$type} LIMIT :aStart, :aLimit";

            $stmt = $this->mDb->connect()->prepare($sql);
            $stmt->bindParam(':category_id', $category_id, PDO::PARAM_INT);
            $stmt->bindParam(':lang_code', $lang_code, PDO::PARAM_STR);
            $stmt->bindParam(':aStart', $aStart, PDO::PARAM_INT);
            $stmt->bindParam(':aLimit', $aLimit, PDO::PARAM_INT);

            // إذا فيه بحث بالاسم نربطه
            if (!empty($searchTitle)) {
                $searchPattern = '%' . $searchTitle . '%';
                $stmt->bindParam(':searchTitle', $searchPattern, PDO::PARAM_STR);
            }

            $stmt->execute();

            $articles = [];

            while ($article = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $maxLength = 10;
                $excerpt = mb_substr(strip_tags($article['content']), 0, $maxLength) . '...';

                $articles[] = [
                    'id'         => $article['id'],
                    'id_category'     => $article['id_category'],
                    'image'      => $article['image'],
                    'sort'       => $article['sort'],
                    'date_added' => $article['date_added'],
                    'title'      => $article['title'],
                    'excerpt'    => $excerpt
                ];
            }

            return [
                'status' => 200,
                'data' => $articles
            ];
        } catch (PDOException $e) {
            return [
                'status' => 500,
                'message' => 'Database Error: ' . $e->getMessage()
            ];
        }
    }
}
