<?php

/*************************************************************************
 *
 *   PROJECT: Tahalya app - Categories API
 *   powered by IT PLUS Team
 *   Copyright 2020 IT Plus Inc
 *   http://it-plus.co/
 * *************************************************************************/

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET,POST,PUT,DELETE,OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

require_once 'init.php';

$postdata = file_get_contents("php://input");
$Req = json_decode($postdata, TRUE);


if ($_GET['action'] == 'getAllWithLang') {

    $lang_code = isset($_GET['lang_code']) ? $_GET['lang_code'] : 'ar';

    $categories = $categoriesObj->getAllCategoriesWithLangs($lang_code);
    $categoriesCount = is_array($categories) ? count($categories) : 0;

    if (!empty($categories)) {
        $Data['data'] = $categories;
        $Data['count'] = $categoriesCount;
        $Data['success'] = true;
    } else {
        $Data['data'] = [];
        $Data['count'] = 0;
        $Data['success'] = false;
    }
}

if ($_GET['action'] == 'getCategoryTree') {
    // if (!isset($_GET['parentId']) || $_GET['parentId'] === ''||$_GET['parentId']<0) {
    //     $Data['status'] = 400;
    //     $Data['success'] = false;
    //     $Data['message'] = "you should enter parent id for searching ";
    //     echo json_encode($Data);
    //     exit;
    // }
    $lang = isset($_GET['lang_code']) ? $_GET['lang_code'] : 'ar';
    $parentId  = isset($_GET['parentId']) ? (int)$_GET['parentId'] : 0;


    $tree = $categoriesObj->getCategoryTree($parentId,$lang);

    $Data['data'] = $tree;
    $Data['success'] = true;
    echo json_encode($Data, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    exit;
}

if ($_GET['action'] == 'getCategoryByParentId') {

    $parentId  = isset($_GET['parentId']) ? (int)$_GET['parentId'] : 0;
    // error_log("parentId from request: " . $parentId);
    $lang_code = isset($_GET['lang_code']) ? $_GET['lang_code'] : 'ar';

    $result = $categoriesObj->getCategoryByParentId($parentId, $lang_code);

    $Data = [
        'status' => 200,
        'success' => true,
        'data' => $result
    ];



    echo json_encode($Data);
    exit;
}



header('Content-Type: application/json');
echo json_encode($Data);



?>