<?php

/* * *************************************************************************
 *
 *   PROJECT: Tahalya app
 *   powerd by IT PLUS Team
 *   Copyright 2020 IT Plus Inc
 *   http://it-plus.co/ *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  */

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET,POST,PUT,DELETE,OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

require_once 'init.php';

$postdata = file_get_contents("php://input");
$Req = json_decode($postdata, TRUE);


if ($_GET['action'] == 'getBankBranches') {

    $latitude = isset($_GET['latitude']) ? floatval($_GET['latitude']) : null;
    $longitude = isset($_GET['longitude']) ? floatval($_GET['longitude']) : null;

    if ($latitude === null || $longitude === null) {
        $Data['data'] = null;
        $Data['msg'] = 'Missing latitude or longitude';
        $Data['success'] = false;
    } else {
        $bankBranchesData = $banksBranchesObj->getBankBranches($_GET['bank_id'], $latitude, $longitude);

        if ($bankBranchesData) {
            $Data['data'] = $bankBranchesData;
            $Data['success'] = true;
        } else {
            $Data['data'] = null;
            $Data['msg'] = 'no_data';
            $Data['success'] = false;
        }
    }
}
echo json_encode($Data);

