<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET,POST,PUT,DELETE,OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

require_once 'init.php';

$postdata = file_get_contents("php://input");
$Req = json_decode($postdata, TRUE);

if ($_GET['action'] == 'getAllBanners') {
    $Data = [
        'data' => [],
        'count' => 0,
        'success' => false
    ];

    $banner_type = isset($_GET['banner_type']) ? trim($_GET['banner_type']) : '';

    try {
        $bannersData = [];

        if ($banner_type === 'main_page') {
            $bannersData = $bannersObj->getAllBannersByType($banner_type);
        } elseif ($banner_type === 'bank_page') {
            if (!isset($_GET['bank_id'])) {
                throw new Exception('Bank ID is required for banner type "bank_page".');
            }

            $bank_id = intval($_GET['bank_id']);
            $bannersData = $bannersObj->getAllBannersByBankId($bank_id);
        } else {
            throw new Exception('Invalid banner type provided.');
        }

        if (!empty($bannersData)) {
            $Data['data'] = $bannersData;
            $Data['success'] = true;
        } else {
            $Data['msg'] = 'No banners found.';
        }
    } catch (Exception $e) {
        $Data['msg'] = $e->getMessage();
    }

    echo json_encode($Data);
}
