
<?php

/*************************************************************************
 *
 *   PROJECT: Tahalya app - Categories API
 *   powered by IT PLUS Team
 *   Copyright 2020 IT Plus Inc
 *   http://it-plus.co/
 * *************************************************************************/

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET,POST,PUT,DELETE,OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

require_once 'init.php';

$postdata = file_get_contents("php://input");
$Req = $_SERVER['REQUEST_METHOD'] === 'POST'
    ? json_decode(file_get_contents("php://input"), true)
    : $_GET;



if (isset($_GET['action']) && $_GET['action'] == 'getOneArticle') {

    $article_id = isset($Req['id']) ? intval($Req['id']) : 0;
    $lang_code  = isset($Req['lang_code']) ? $Req['lang_code'] : 'ar';
    $aStart    = isset($Req['aStart']) ? intval($Req['aStart']) : 0;
    $aLimit    = isset($Req['aLimit']) ? intval($Req['aLimit']) : 10;
    $id_user = isset($AuthUser['id']) ? intval($AuthUser['id']) : 0;

    $result = $articlesObj->getOneArticle($article_id, $lang_code, $aStart,$aLimit, $id_user);

    if (isset($result['status']) && $result['status'] == 200) {
        $Data['data'] = $result['data'];
        $Data['success'] = true;
    } else {
        $Data['data'] = $result;
        $Data['success'] = false;
        $Data['msg'] = $result['message'] ?? 'Error';
    }

    echo json_encode($Data, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    exit;
}

if ($_GET['action'] == 'incrementViews') {
    $article_id = isset($_GET['article_id']) ? intval($_GET['article_id']) : 0;

    $result = $articlesObj->incrementArticleViews($article_id);

    if (isset($result['status']) && $result['status'] == 500) {
        $Data['data'] = $result;
        $Data['success'] = false;
        $Data['msg'] = 'failed';
    } else {
        $Data['data'] = $result;
        $Data['success'] = true;
        $Data['msg'] = 'View incremented';
    }

    echo json_encode($Data, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    exit;
}

if ($_GET['action'] == 'getArticlePath') {

    $article_id = isset($_GET['article_id']) ? intval($_GET['article_id']) : 0;
    $lang_code  = isset($_GET['lang_code']) ? $_GET['lang_code'] : 'ar';

    if ($article_id <= 0) {
        echo json_encode([
            'success' => false,
            'msg' => 'Invalid article ID',
            'data' => ['status' => 400]
        ], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
        exit;
    }

    $result = $articlesObj->buildArticlePath($article_id, $lang_code);

    if (isset($result['status']) && $result['status'] == 200) {
        echo json_encode([
            'success' => true,
            'msg' => 'Path generated successfully',
            'data' => [
                'article_id' => $article_id,
                'path'       => $result['path']
            ]
        ], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    } else {
        echo json_encode([
            'success' => false,
            'msg' => $result['message'] ?? 'Failed to generate path',
            'data' => [
                'status' => $result['status'] ?? 500
            ]
        ], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    }

    exit;
}

if (isset($_GET['action']) && $_GET['action'] === 'getArticlesList') {

    $category_id = isset($_GET['category_id']) ? intval($_GET['category_id']) : 0;
    $lang_code   = isset($_GET['lang_code']) ? $_GET['lang_code'] : 'ar';
    $aStart      = isset($_GET['aStart']) ? intval($_GET['aStart']) : 0;
    $aLimit      = isset($_GET['aLimit']) ? intval($_GET['aLimit']) : 100;
    $type        = isset($_GET['type']) ? strtoupper($_GET['type']) : 'DESC';
    $searchTitle = isset($_GET['searchTitle']) ? trim($_GET['searchTitle']) : '';

    if ($category_id <= 0) {
        echo json_encode([
            'success' => false,
            'msg'     => 'Invalid category ID',
            'data'    => ['status' => 400]
        ], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
        exit;
    }

    // استدعاء الدالة مع البحث الاختياري
    $result = $articlesObj->getArticlesList($category_id, $lang_code, $aStart, $aLimit, $type, $searchTitle);

    if (isset($result['status']) && $result['status'] != 200) {
        echo json_encode([
            'success' => false,
            'msg'     => 'Failed to fetch articles',
            'data'    => $result
        ], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
        exit;
    }

    echo json_encode([
        'success' => true,
        'msg'     => 'Articles fetched successfully',
        'count'   => count($result['data']),
        'data'    => $result['data']
    ], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    exit;
}
