<?php

/* * *************************************************************************
 *
 *   PROJECT: Tahalya app
 *   powerd by IT PLUS Team
 *   Copyright 2020 IT Plus Inc
 *   http://it-plus.co/ *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  */

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET,POST,PUT,DELETE,OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

require_once 'init.php';

$postdata = file_get_contents("php://input");


// if (isset($_POST['action']) && $_POST['action'] === 'uploadImage') {
//     $temp = array();

//     $allow_ext = array("jpg","gif","png","jpeg","bmp","webp");
//     $video_ext = array('mp4','avi','wmv','flv','mkv','webm');
//     $maxsize = 1024 * 1024 * 1024*20; 

//     $folder = $_POST['folder'] ?? 'default';
//     $uploadFolder = $Config['uploads_path'] . $folder;
//     // $uploadFolder = $Config['uploads_path'] . 'categories';
//     $fullPath = $_SERVER['DOCUMENT_ROOT'] . '/' . $uploadFolder;


//     // echo "UPLOAD PATH: " . $fullPath . "<br>";
//     // echo "EXISTS: " . (is_dir($fullPath) ? 'YES' : 'NO') . "<br>";
//     // echo "WRITABLE: " . (is_writable($fullPath) ? 'YES' : 'NO') . "<br>";


//     $folderWhichTakeThumb = $_POST['folder'] ?? 'default';

//     if ($folderWhichTakeThumb === 'categories') {
//         $thumbsConfig = array(
//             array(
//                 'name' => 'medium',
//                 'width' => 240,
//                 'hight' => 250
//             ),
//             array(
//                 'name' => 'small',
//                 'width' => 80,
//                 'hight' => 80
//             ),
//         );
//     } else {
//         $folderWhichTakeThumb = false;
//         $thumbsConfig = []; // لا يتم إنشاء  
//     }


//     // تأكد من وجود مجلد /uploads/banks/thumbs
//     $targetPath = $_SERVER['DOCUMENT_ROOT'] . '/' . $Config['uploads_path'] . $folder . '/thumbs';
//     if (!is_dir($targetPath)) {
//         mkdir($targetPath, 0777, true);
//     }


//     $upload = new Upload($allow_ext, $thumbsConfig, $maxsize, $uploadFolder, $folderWhichTakeThumb);

//     if (isset($_FILES['file']['name']) && $_FILES['file']['name'] != '') {
//         $file['name'] = addslashes($_FILES["file"]["name"]);
//         $file['type'] = $_FILES["file"]['type'];
//         $file['size'] = $_FILES["file"]['size'] / 1024;
//         $file['tmp']  = $_FILES["file"]['tmp_name'];
//         $file['ext']  = $upload->GetExt($_FILES["file"]["name"]);

//         if ($file['name'] != null) {
//             $upfile = $upload->Upload_File($file, $maxsize);

//             if ($upfile) {
//                 $Data = [
//                     'status' => 200,
//                     'message' => 'تم رفع الصورة بنجاح',
//                     'file' => $upfile['newname'],
//                     'keywords' => $upfile['keywords'] ?? '',
//                     'thumbs' => [
//                         'medium' => $Config['uploads_path'] . $folder . '/thumbs/medium_' . $upfile['newname'],
//                         'small' => $Config['uploads_path'] . $folder . '/thumbs/small_' . $upfile['newname']
//                     ],
//                 ];
//             } else {
//                 $error = true;
//                 $showError[] = $upload->showErrors();
//                 $Data = [
//                     'status' => 500,
//                     'message' => $showError[0][0] ?? 'حدث خطأ أثناء رفع الصورة',


//                 ];
//             }
//         }
//     } else {
//         $Data = [
//             'status' => 400,
//             'message' => 'لم يتم اختيار ملف للرفع'
//         ];
//     }

//     header('Content-Type: application/json');
//     echo json_encode($Data, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
//     exit;
// }





if (isset($_POST['action']) && $_POST['action'] === 'uploadFile') {
    $temp = array();

    $allow_ext = array("jpg", "gif", "png", "jpeg", "bmp", "webp", "mp4", "avi", "wmv", "flv", "mkv", "webm");
    $image_ext = array("jpg", "gif", "png", "jpeg", "bmp", "webp");
    $video_ext = array('mp4', 'avi', 'wmv', 'flv', 'mkv', 'webm');
    $maxsize = 1024 * 10; // 10MB

    $folder = $_POST['folder'] ?? 'default';
    $uploadFolder = $Config['uploads_path'] . $folder;
    $fullPath = $_SERVER['DOCUMENT_ROOT'] . '/' . $uploadFolder;

    if (isset($_FILES['file']['name']) && $_FILES['file']['name'] != '') {
        $file['name'] = addslashes($_FILES["file"]["name"]);
        $file['type'] = $_FILES["file"]['type'];
        $file['size'] = $_FILES["file"]['size'] / 1024;
        $file['tmp']  = $_FILES["file"]['tmp_name'];
        $file['ext']  = strtolower(pathinfo($_FILES["file"]["name"], PATHINFO_EXTENSION));

        if (!in_array($file['ext'], $allow_ext)) {
            $Data = [
                'status' => 400,
                'message' => 'الملف المرفوع غير مدعوم',
            ];
        } else {
            $isVideo = in_array($file['ext'], $video_ext);
            $thumbsConfig = [];
            $folderWhichTakeThumb = false;

            if (!$isVideo) {

                if ($folder === 'categories' || $folder === 'atms') {
                    $thumbsConfig = array(
                        array(
                            'name' => 'medium',
                            'width' => 240,
                            'hight' => 250
                        ),
                        array(
                            'name' => 'small',
                            'width' => 80,
                            'hight' => 80
                        ),
                    );
                    $targetPath = $_SERVER['DOCUMENT_ROOT'] . '/' . $Config['uploads_path'] . $folder . '/thumbs';
                    if (!is_dir($targetPath)) {
                        mkdir($targetPath, 0777, true);
                        // إنشاء ملف index.html 
                        $indexFile = $targetPath . '/index.html';
                        file_put_contents($indexFile, '');
                    }

                    $folderWhichTakeThumb = true;
                }
            }


            $upload = new Upload($allow_ext, $thumbsConfig, $maxsize, $uploadFolder, $folderWhichTakeThumb);
            $upfile = $upload->Upload_File($file, $maxsize);

            if ($upfile) {
                $Data = [
                    'status' => 200,
                    'message' => $isVideo ? 'تم رفع الفيديو بنجاح' : 'تم رفع الصورة بنجاح',
                    'file' => $upfile['newname'],
                    'keywords' => $upfile['keywords'] ?? '',
                ];

                if (!$isVideo && !empty($thumbsConfig)) {
                    $Data['thumbs'] = [
                        'medium' => $Config['uploads_path'] . $folder . '/thumbs/medium_' . $upfile['newname'],
                        'small' => $Config['uploads_path'] . $folder . '/thumbs/small_' . $upfile['newname'],
                    ];
                }
            } else {
                $error = true;
                $showError[] = $upload->showErrors();
                $Data = [
                    'status' => 500,
                    'message' => $showError[0][0] ?? 'حدث خطأ أثناء رفع الملف',
                ];
            }
        }
    } else {
        $Data = [
            'status' => 400,
            'message' => 'لم يتم اختيار ملف للرفع'
        ];
    }

    header('Content-Type: application/json');
    echo json_encode($Data, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    exit;
}


