<?php

/* * *************************************************************************
 *
 *   PROJECT: Tahalya app
 *   powerd by IT PLUS Team
 *   Copyright 2020 IT Plus Inc
 *   http://it-plus.co/ *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  */

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET,POST,PUT,DELETE,OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

require_once 'init.php';

$postdata = file_get_contents("php://input");

if ($_GET['action'] == 'getAllLanguages') {

    $start = $_GET['start'] ? $_GET['start'] : 0;
    $aItemsPerPage = $_GET['aItemsPerPage'] ? $_GET['aItemsPerPage'] : 5;

    $sort = $_GET['sort'] ? $_GET['sort'] : 'id';
    $type = $_GET['type'] ? $_GET['type'] : 'DESC';

    $searchName = $_GET['searchName'] ? $_GET['searchName'] : '';

    $count = $langObj->getSearchLanguagesCount($searchName);
    $data = $langObj->getAllLanguages($start, $aItemsPerPage, $sort, $type, $searchName);
    if ($data) {
        $Data['data'] = $data;
        $Data['count'] = $count;
        $Data['success'] = true;
      } else {
        $Data['data'] = [];
        $Data['count'] = 0;
        $Data['success'] = false;
      }

}
if ($_GET['action'] == 'addEditLanguage') {
    $temp = array();

    $allow_ext = array("jpg", "gif", "png", "jpeg", "bmp", "webp");
    $maxsize = 1024 * 20; //kb

    $uploadFolder = $Config['uploads_path'] . 'languages';

    $thumbsConfig = array(
        array(
            'name' => 'medium',
            'width' => '240',
            'hight' => '250'
        ),
        array(
            'name' => 'small',
            'width' => '80',
            'hight' => '80'
        ),
    );

    $upload = new Upload($allow_ext, $thumbsConfig, $maxsize, $uploadFolder, false);

    // Check if a file is uploaded
    if (isset($_FILES['file']['name']) && $_FILES['file']['name'] != '') {
        // Get file data
        $file['name'] = addslashes($_FILES["file"]["name"]);
        $file['type'] = $_FILES["file"]['type'];
        $file['size'] = $_FILES["file"]['size'] / 1024;
        $file['tmp'] = $_FILES["file"]['tmp_name'];
        $file['ext'] = $upload->GetExt($_FILES["file"]["name"]);

        if ($file['name'] != '') {
            // Upload file
            $upfile = $upload->Upload_File($file, $maxsize);

            if ($upfile) {
                // Add file to the $temp array
                $temp['file'] = $upfile['newname'];
            } else {
                $error = true;
                $showError[] = $upload->showErrors();
                $top_msg['error'][] = $showError[0][0];
            }
        }
    } else {

        $temp['file'] = null;
    }
    $temp = array_merge($temp, $_REQUEST);

    $Data = $langObj->addEditLanguage($temp);
}


if ($_GET['action'] == 'getOneLanguage') {

    $Data = $langObj->getOneLanguage($_REQUEST['id']);

}


if ($_GET['action'] == 'deleteLanguage' && $_SERVER['REQUEST_METHOD'] == 'POST') {

    if (isset($_POST['ids'])) {
    
        $ids = is_array($_POST['ids']) ? $_POST['ids'] : explode(',', $_POST['ids']);
        $deletedData = $langObj->deleteLanguage($ids);

        if ($deletedData) {
            $Data['data'] = $deletedData;
            $Data['success'] = true;
        } else {
            $Data['data'] = null;
            $Data['msg'] = 'no_data';
            $Data['success'] = false;
        }
    } else {
        $Data['msg'] = 'No ID provided';
        $Data['success'] = false;
    }


}

echo json_encode($Data);
