<?php

date_default_timezone_set('Africa/Cairo');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET,POST,PUT,DELETE,OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, User-Token, Authorization, X-Requested-With, access-control-allow-origin, lang-code');
require_once '../php-jwt-6.0.0/src/JWT.php';
// Function to mimic apache_request_headers() if not available
if (!function_exists('apache_request_headers')) {
    function apache_request_headers() {
        $arh = array();
        $rx_http = '/\AHTTP_/';
        foreach ($_SERVER as $key => $val) {
            if (preg_match($rx_http, $key)) {
                $arh_key = preg_replace($rx_http, '', $key);
                $rx_matches = array();
                // Restore original letter case
                $rx_matches = explode('_', strtolower($arh_key));
                if (count($rx_matches) > 0 && strlen($arh_key) > 2) {
                    foreach ($rx_matches as $ak_key => $ak_val)
                        $rx_matches[$ak_key] = ucfirst($ak_val);
                    $arh_key = implode('-', $rx_matches);
                }
                $arh[$arh_key] = $val;
            }
        }
        if (isset($_SERVER['CONTENT_TYPE']))
            $arh['Content-Type'] = $_SERVER['CONTENT_TYPE'];
        if (isset($_SERVER['CONTENT_LENGTH']))
            $arh['Content-Length'] = $_SERVER['CONTENT_LENGTH'];
        return $arh;
    }
}

$headers = apache_request_headers();

// print_r($headers);die();
$langCode = isset($headers['Lang-Code']) ? $headers['Lang-Code'] : 'en'; 
// $data_offset = isset($headers['Date-Offset']) ? $headers['Date-Offset'] : 'Africa/Cairo'; 

$supportedLanguages = ['en', 'ar']; 


define('LANGUAGE', in_array($langCode, $supportedLanguages) ? $langCode : 'en');
// define('TIME_ZONE', $headers['Date-Offset']);


// require_once '../Currency-Spidey/src/CurrencySpidey.php';
require '../../vendor/autoload.php';
require_once '../includes/config.inc.php';
require_once 'classes/plusMailer.php';
require_once 'classes/upload-class.php';
require_once 'classes/iplus.php';
require_once 'classes/class.hs256.php';
require_once 'classes/class.pages.php';
require_once 'classes/class.languages.php';
require_once 'classes/class.comments.php';
require_once 'classes/class.comment_reactions.php';


require_once 'classes/class.users.php';
require_once 'classes/class.levels.php';
require_once 'classes/class.banks.php';
require_once 'classes/class.branches.php';
require_once 'classes/class.atms.php';
require_once 'classes/class.banners.php';
require_once 'classes/class.currencies.php';
require_once 'classes/class.atm_maintenance.php';
require_once 'classes/class.categories.php';
require_once 'classes/class.articles.php';
require_once '../../utils/util.php';
?>
