<?php

/*************************************************************************
 *
 *   PROJECT: Tahalya app - Categories API
 *   powered by IT PLUS Team
 *   Copyright 2020 IT Plus Inc
 *   http://it-plus.co/
 * *************************************************************************/

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET,POST,PUT,DELETE,OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

require_once 'init.php';

$postdata = file_get_contents("php://input");
$Req = json_decode($postdata, TRUE);


if ($_GET['action'] == 'getArticleWithDetails') {
    if (!isset($Req['id_article']) || !is_numeric($Req['id_article'])) {
        $Data = [
            "status" => 400,
            "message" => "Missing or invalid id_article parameter"
        ];
    } else {
        $id_article = intval($Req['id_article']);
        $aStart = isset($Req['aStart']) ? intval($Req['aStart']) : 0;
        $aLimit = isset($Req['aLimit']) ? intval($Req['aLimit']) : 10;

        $commentsList = $commentsObj->getArticleWithDetails($id_article, $aStart, $aLimit);

        $Data = [
            "status" => 200,
            "success" => true,
            "msg" => "success",
            "data" => $commentsList
        ];
    }

    echo json_encode($Data, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    exit;
}



if ($_GET['action'] == 'deleteComment') {
    if (!isset($Req['ids']) || !is_array($Req['ids'])) {
        $Data = [
            "status" => 400,
            "message" => "Missing or invalid 'ids' parameter. Provide an array of comment IDs."
        ];
    } else {
        $Data = $commentsObj->deleteComments($Req['ids']);
    }

    echo json_encode($Data);
    exit;
}

if ($_GET['action'] == 'getComments') {
    $id_article = isset($_GET['id_article']) ? intval($_GET['id_article']) : 0;
    $parent_id = isset($_GET['parent_id']) ? intval($_GET['parent_id']) : null;
    $aStart = isset($_GET['aStart']) ? intval($_GET['aStart']) : 0;
    $aLimit = isset($_GET['aLimit']) ? intval($_GET['aLimit']) : 10;

    if ($id_article <= 0) {
        $Data = ["status" => 400, "message" => "Invalid 'id_article'"];
    } else {
        $result = $commentsObj->getComments($id_article, $aStart, $aLimit, $parent_id);

        $Data = [
            "status" => 200,
            "success" => true,
            "msg" => "Loaded successfully",
            "data" => $result
        ];
    }

    echo json_encode($Data, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    exit;
}



header('Content-Type: application/json');
echo json_encode($Data);
