<?php

/*************************************************************************
 *
 *   PROJECT: Tahalya app - Categories API
 *   powered by IT PLUS Team
 *   Copyright 2020 IT Plus Inc
 *   http://it-plus.co/
 * *************************************************************************/

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET,POST,PUT,DELETE,OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

require_once 'init.php';

$postdata = file_get_contents("php://input");
$Req = json_decode($postdata, TRUE);

if ($_GET['action'] === 'CommentReaction') {
    // 🔹 استخراج القيم من JSON Body
    $comment_id = isset($Req['comment_id']) ? intval($Req['comment_id']) : 0;
    $user_id = isset($Req['user_id']) ? intval($Req['user_id']) : 0;
    $reaction_type = isset($Req['reaction_type']) ? $Req['reaction_type'] : '';
if ($comment_id > 0 && $user_id > 0 && $reaction_type!=null) {
    $addedData = $comment_reactionsObj->likeOrDislikeComment($comment_id, $user_id, $reaction_type);
}else{
    $addedData = ['status' => 400, 'message' => 'comment_id و user_id و reaction_type required'];
}
    $Data = [];
    if ($addedData['status'] == 200) {
        $Data['success'] = true;
        $Data['data'] = $addedData;
    } else {
        $Data['success'] = false;
        $Data['msg'] = $addedData['message'];
    }
}

if ($_GET['action'] === 'GetCount') {
    $comment_id = isset($Req['comment_id']) ? intval($Req['comment_id']) : 0;
    if (!$comment_id) {
        echo json_encode(['status' => 400, 'message' => 'comment_id مطلوب'], JSON_UNESCAPED_UNICODE);
        exit;
    }

    $result = $comment_reactionsObj->getCommentReactionsCount($comment_id);
    echo json_encode($result, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
}

if ($_GET['action'] === 'GetUserReaction') {
    $comment_id = isset($Req['comment_id']) ? intval($Req['comment_id']) : 0;
    $user_id = isset($Req['user_id']) ? intval($Req['user_id']) : 0;

    if (!$comment_id || !$user_id) {
        echo json_encode(['status' => 400, 'message' => 'comment_id و user_id مطلوبين'], JSON_UNESCAPED_UNICODE);
        exit;
    }

    $result = $comment_reactionsObj->getUserReactionForComment($comment_id, $user_id);
    echo json_encode($result, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    exit;
}

// if ($_GET['action'] == 'removeUserReaction' && $_SERVER['REQUEST_METHOD'] == 'POST') {
//     $comment_id = isset($Req['comment_id']) ? intval($Req['comment_id']) : 0;
//     $user_id = isset($Req['user_id']) ? intval($Req['user_id']) : 0;
//     $reaction_type = isset($Req['reaction_type']) ? $Req['reaction_type'] : null;   
//     if ($comment_id > 0 && $user_id > 0 && $reaction_type!=null) {

//         $removed = $comment_reactionsObj->removeUserReaction($comment_id, $user_idو $reaction_type);

//         if ($removed) {
//             $Data['success'] = true;
//             $Data['msg'] = 'reaction_removed';
//         } else {
//             $Data['success'] = false;
//             $Data['msg'] = 'reaction_not_found_or_failed';
//         }
//     } else {
//         $Data['success'] = false;
//         $Data['msg'] = 'missing_comment_id_or_user_id';
//     }
// }


header('Content-Type: application/json');

exit;
