<?php

$pagesObj = new pages();

class pages
{

	var $mDb;
	var $mConfig;
	var $mlang;
    

	function __construct()
	{
		global $Config;
		global $Lang;
		$this->mDb = new iplus();
		$this->mConfig = $Config;
		$this->mlang = $Lang;
     
	}


	function convert_object_to_array($data)
	{

		if (is_object($data)) {
			$data = get_object_vars($data);
		}

		if (is_array($data)) {
			return array_map(__METHOD__, $data);
		} else {
			return $data;
		}
	}
    function getAllPages($aStart, $aLimit, $sort, $type, $searchTitle) {
        $lang_code = LANGUAGE;
        
        $sql = "SELECT p.id, p.added_by, p.status, p.date_added, pl.description, pl.title, p.img
                FROM pages p
                LEFT JOIN pages_langs pl ON p.id = pl.page_id AND pl.lang_code = :lang_code
                WHERE p.id > 0 ";
    
        if ($searchTitle) {
            $sql .= " AND pl.title LIKE :searchTitle";
        }
        if ($sort == 'title') {
            $sql .= " ORDER BY pl.title {$type}";
        } else {
            $sql .= " ORDER BY p.{$sort} {$type}";
        }
        if ($aLimit) {
            $sql .= " LIMIT :aStart, :aLimit";
        }
    
        try {
            $this->mDb->connect()->beginTransaction();  // Start transaction
    
            $stmt = $this->mDb->connect()->prepare($sql);
            $stmt->bindParam(':lang_code', $lang_code, PDO::PARAM_STR);
    
            if ($searchTitle) {
                $stmt->bindParam(':searchTitle', $searchTitle, PDO::PARAM_STR);
            }
    
            if ($aLimit) {
                $stmt->bindParam(':aStart', $aStart, PDO::PARAM_INT);
                $stmt->bindParam(':aLimit', $aLimit, PDO::PARAM_INT);
            }
    
            $stmt->execute();
            $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
            $this->mDb->connect()->commit();  // Commit transaction
            return $results;
    
        } catch (PDOException $e) {
            $this->mDb->connect()->rollBack();  // Rollback transaction on error
            error_log("PDOException in getAllPages: " . $e->getMessage());
            return array();
        }
    }
    
    function getSearchPagesCount($searchTitle) {
        $lang_code = LANGUAGE;
        $sql = "SELECT COUNT(p.`id`) as result_count 
                FROM pages p
                LEFT JOIN pages_langs pl ON p.id = pl.page_id AND pl.lang_code = :lang_code
                WHERE p.`id` > 0 ";
    
        if (!empty($searchTitle)) {
            $sql .= " AND pl.title LIKE :searchTitle";
        }
    
        try {
            $this->mDb->connect()->beginTransaction();  // Start transaction
    
            $stmt = $this->mDb->connect()->prepare($sql);
            $stmt->bindParam(':lang_code', $lang_code, PDO::PARAM_STR);
    
            if (!empty($searchTitle)) {
                $stmt->bindParam(':searchTitle', $searchTitle, PDO::PARAM_STR);
            }
    
            $stmt->execute();
            $resultCount = $stmt->fetchColumn();
    
            $this->mDb->connect()->commit();  // Commit transaction
            return $resultCount;
    
        } catch (PDOException $e) {
            $this->mDb->connect()->rollBack();  // Rollback transaction on error
            error_log("PDOException in getSearchPagesCount: " . $e->getMessage());
            return 0;
        }
    }
    

function addEditPage($request) {
    // Validate added_by to be an integer
    if (isset($request['added_by']) && !is_int($request['added_by']) && !ctype_digit($request['added_by'])) {
        return ["status" => 400, "message" => "'added_by' must be an integer"];
    }
// print_r($request);die();
    unset($request['action']);
    $dataLangObj = json_decode($request['langs']);
    $newDataLangObj = $this->convert_object_to_array($dataLangObj);
    $dateTime = date('Y-m-d H:i:s');

    $addedBy = isset($request['added_by']) ? (int)$request['added_by'] : 0;

    if (!$request['id']) {
        // Insert operation
        $sql = "INSERT INTO pages SET added_by = :added_by, date_added = :dateTime";
        $sql .= ", status = :status";
        $sql .= ", img = :img";
        try {
            $this->mDb->beginTransaction();
            $stmt = $this->mDb->connect()->prepare($sql);
            $stmt->bindParam(':added_by', $addedBy, PDO::PARAM_INT);
            $stmt->bindParam(':dateTime', $dateTime);
            $stmt->bindParam(':status', $request['status'], PDO::PARAM_INT);
            $stmt->bindParam(':img', $request['file']);
            $stmt->execute();

            $last_page_id = $this->mDb->getLastInsertId();
            foreach ($newDataLangObj as $key => $value) {
                $sqlForLang = "INSERT INTO pages_langs SET page_id = :page_id, lang_code = :lang_code, title = :title, description = :description";

                $stmtForLang = $this->mDb->connect()->prepare($sqlForLang);
                $stmtForLang->bindParam(':page_id', $last_page_id, PDO::PARAM_INT);
                $stmtForLang->bindParam(':lang_code', $value['lang_code']);
                $stmtForLang->bindParam(':title', $value['title']);
                $stmtForLang->bindParam(':description', $value['description']);
                $stmtForLang->execute();
            }

            $this->mDb->commit();

            return ["status" => 200, "message" => $request];
        } catch (PDOException $e) {
            $this->mDb->rollBack();
            if (isset($request['file'])) {
                $eroredimg = $_SERVER['DOCUMENT_ROOT'] . '/' . $this->mConfig['uploads_path'] . 'pages/' . $request['file'];
                if (file_exists($eroredimg)) unlink($eroredimg);
            }
            return ["status" => 500, "message" => "An Error Occurred"];
        }
    } else {
        // Update operation
        $sql = "UPDATE pages SET";
        try {
            $this->mDb->beginTransaction();

            if (isset($request['file'])) {
                $sqlForImage = "SELECT img FROM pages WHERE id = :id";
                $stmtForImage = $this->mDb->connect()->prepare($sqlForImage);
                $stmtForImage->bindParam(':id', $request['id'], PDO::PARAM_INT);
                $stmtForImage->execute();
                $PageImage = $stmtForImage->fetch(PDO::FETCH_COLUMN);
            }

            $updateFields = [];
            if (isset($request['status'])) $updateFields[] = "status = :status";
            if (isset($request['file'])) $updateFields[] = "img = :img";
            if (isset($request['added_by'])) $updateFields[] = "added_by = :added_by";

            if (count($updateFields) > 0) {
                $sql .= implode(", ", $updateFields) . " WHERE id = :id";
                $stmt = $this->mDb->connect()->prepare($sql);
                if (isset($request['file'])) $stmt->bindParam(':img', $request['file']);
                if (isset($request['status'])) $stmt->bindParam(':status', $request['status'], PDO::PARAM_INT);
                if (isset($request['added_by'])) $stmt->bindParam(':added_by', $request['added_by'], PDO::PARAM_INT);
                $stmt->bindParam(':id', $request['id'], PDO::PARAM_INT);
                $stmt->execute();
            }

            foreach ($newDataLangObj as $key => $value) {
                $sqlForGymLang = 'UPDATE pages_langs SET';
                $updateFieldsLang = [];
                if (!empty($value['title'])) $updateFieldsLang[] = "title = :title";
                if (!empty($value['description'])) $updateFieldsLang[] = "description = :description";

                if (count($updateFieldsLang) > 0) {
                    $sqlForGymLang .= implode(", ", $updateFieldsLang);
                    $sqlForGymLang .= " WHERE page_id = :pageId AND lang_code = :lang_code";

                    $stmtForLang = $this->mDb->connect()->prepare($sqlForGymLang);
                    if (!empty($value['title'])) $stmtForLang->bindParam(':title', $value['title']);
                    if (!empty($value['description'])) $stmtForLang->bindParam(':description', $value['description']);
                    $stmtForLang->bindParam(':pageId', $request['id'], PDO::PARAM_INT);
                    $stmtForLang->bindParam(':lang_code', $value['lang_code']);
                    $stmtForLang->execute();
                }
            }

            if (isset($request['file'])) {
                $eroredimg = $_SERVER['DOCUMENT_ROOT'] . '/' . $this->mConfig['uploads_path'] . 'pages/' . $PageImage;
                if (file_exists($eroredimg)) unlink($eroredimg);
            }

            $this->mDb->commit();
            return ["status" => 200, "message" => "Updated"];
        } catch (PDOException $e) {
            $this->mDb->rollBack();
            if (isset($request['file'])) {
                $eroredimg = $_SERVER['DOCUMENT_ROOT'] . '/' . $this->mConfig['uploads_path'] . 'pages/' . $request['file'];
                if (file_exists($eroredimg)) unlink($eroredimg);
            }
            return ["status" => 500, "message" => "An error occurred"];
        }
    }
}





function getOnePage($id) {
    try {
        // Begin the transaction
        $this->mDb->beginTransaction();

        // Main SQL query to retrieve page details
        $sql = "SELECT p.`id`, p.`added_by`, p.`status`, p.`date_added`, p.`img` 
                FROM `pages` p WHERE p.`id` = :id";

        $stmt = $this->mDb->connect()->prepare($sql);
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);

        if ($stmt->execute()) {
            $result = $stmt->fetch(PDO::FETCH_ASSOC);
            if (!$result) {
                throw new Exception("Page with ID $id not found.");
            }
        } else {
            throw new Exception("Error executing the main SQL statement: " . implode(", ", $stmt->errorInfo()));
        }

        // SQL query to retrieve languages related to the page
        $sqlLangs = "SELECT pl.`lang_code`, pl.`title`, pl.`description` 
                     FROM `pages_langs` pl WHERE pl.`page_id` = :id";
        $stmtLangs = $this->mDb->connect()->prepare($sqlLangs);
        $stmtLangs->bindParam(':id', $id, PDO::PARAM_INT);

        if ($stmtLangs->execute()) {
            $result['langs'] = $stmtLangs->fetchAll(PDO::FETCH_ASSOC);
        } else {
            throw new Exception("Error executing the languages SQL statement: " . implode(", ", $stmtLangs->errorInfo()));
        }

        // Commit the transaction after both queries are successful
        $this->mDb->commit();

        return $result;
    } catch (Exception $e) {
        // Rollback in case of any error
        $this->mDb->rollBack();
        return ["status" => 500, "message" => "An error occurred: " . $e->getMessage()];
    }
}


function deletePage($ids) {
    if (empty($ids) || !is_array($ids)) {
        return false;
    }

    // Begin a transaction to ensure data consistency
    try {
        $this->mDb->beginTransaction();

        // Prepare placeholders for the IDs
        $placeholders = implode(',', array_fill(0, count($ids), '?'));

        $sqlDeleteLangs = "DELETE FROM `pages_langs` WHERE `page_id` IN ($placeholders)";
        $stmtDeleteLangs = $this->mDb->connect()->prepare($sqlDeleteLangs);
        $stmtDeleteLangs->execute($ids);
        // Select associated images to be deleted
        $sqlSelectImages = "SELECT `img` FROM `pages` WHERE `id` IN ($placeholders)";
        $stmtSelectImages = $this->mDb->connect()->prepare($sqlSelectImages);
        $stmtSelectImages->execute($ids);
        $images = $stmtSelectImages->fetchAll(PDO::FETCH_ASSOC);


        if (!empty($images)) {
            foreach ($images as $image) {
                $old_img = $_SERVER['DOCUMENT_ROOT'] . '/' . $this->mConfig['uploads_path'] . 'pages/' . $image['img'];
                if (file_exists($old_img)) {
                    @unlink($old_img); 
                }
            }
        }

        // Delete the pages
        $sqlDeletePages = "DELETE FROM `pages` WHERE `id` IN ($placeholders)";
        $stmtDeletePages = $this->mDb->connect()->prepare($sqlDeletePages);
        $stmtDeletePages->execute($ids);

        // Commit the transaction
        $this->mDb->commit();

        return true;
    } catch (PDOException $e) {
        // Rollback in case of error
        $this->mDb->rollBack();
        error_log("PDOException in deletePage: " . $e->getMessage());
        return false;
    }
}


} ?>