<?php

$levelsObj = new levels(); 

class levels {

var $mDb; 
var $mConfig; 

function __construct() {
	global $Config; 
	$this -> mDb = new iplus(); 
	$this -> mConfig = $Config; 
}


function getSomeLevels($aStart, $aLimit, $sort, $type, $searchName)
{
    try {
        $this->mDb->connect()->beginTransaction(); 

        $sql = "SELECT l.id, l.level_name, l.date_added
                FROM `user_levels` l 
                WHERE l.id > 0";
        
        if (!empty($searchName)) {
            $sql .= " AND l.level_name LIKE :searchName";
        }

        $sql .= " ORDER BY l.{$sort} {$type}";
        if ($aLimit) {
            $sql .= " LIMIT :aStart, :aLimit";
        }

        $stmt = $this->mDb->connect()->prepare($sql);

        if (!empty($searchName)) {
            $stmt->bindParam(':searchName', $searchName, PDO::PARAM_STR);
        }

        if ($aLimit) {
            $stmt->bindParam(':aStart', $aStart, PDO::PARAM_INT);
            $stmt->bindParam(':aLimit', $aLimit, PDO::PARAM_INT);
        }

        $stmt->execute();
        $this->mDb->connect()->commit(); 

        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    } catch (Exception $e) {
        $this->mDb->connect()->rollBack(); 
        return [
            "status" => 500,
            "message" => "Error: " . $e->getMessage(),
        ];
    }
}

function getSearchLevelsCount($sort, $type, $searchName)
{
    try {
        $this->mDb->connect()->beginTransaction();

        $sql = "SELECT COUNT(`id`) as 'result_count' 
                FROM `user_levels` 
                WHERE `id` > 0";

        if (!empty($searchName)) {
            $sql .= " AND `level_name` LIKE :searchName";
        }

        $sql .= " ORDER BY {$sort} {$type}";

        $stmt = $this->mDb->connect()->prepare($sql);

        if (!empty($searchName)) {
            $searchName = "%{$searchName}%";
            $stmt->bindParam(':searchName', $searchName, PDO::PARAM_STR);
        }

        $stmt->execute();
        $this->mDb->connect()->commit();

        return $stmt->fetch(PDO::FETCH_ASSOC)['result_count'];
    } catch (Exception $e) {
        $this->mDb->connect()->rollBack();
        return [
            "status" => 500,
            "message" => "Error: " . $e->getMessage(),
        ];
    }
}
function addEditLevel($temp)
{
    try {
        $this->mDb->connect()->beginTransaction(); 

        if (empty($temp['id'])) {
            unset($temp['id']);

            $dateTime = date('Y-m-d H:i:s');
            $sql = "INSERT INTO `user_levels` (";
            $fields = [];
            $placeholders = [];
            foreach ($temp as $k => $v) {
                $fields[] = "`{$k}`";
                $placeholders[] = ":{$k}";
            }
            $fields[] = "`date_added`";
            $placeholders[] = ":date_added";

            $sql .= implode(", ", $fields) . ") VALUES (" . implode(", ", $placeholders) . ")";

            $stmt = $this->mDb->connect()->prepare($sql);
            foreach ($temp as $k => $v) {
                $stmt->bindParam(":{$k}", $v === '' ? $zero = 0 : $temp[$k]);
            }
            $stmt->bindParam(":date_added", $dateTime);
        } else {
            $sql = "UPDATE `user_levels` SET ";
            $updates = [];
            foreach ($temp as $k => $v) {
                $updates[] = "`{$k}` = :{$k}";
            }
            $sql .= implode(", ", $updates) . " WHERE `id` = :id";

            $stmt = $this->mDb->connect()->prepare($sql);
            foreach ($temp as $k => $v) {
                $stmt->bindParam(":{$k}", $v === '' ? $zero = 0 : $temp[$k]);
            }
            $stmt->bindParam(":id", $temp['id'], PDO::PARAM_INT);
        }

        $stmt->execute();
        $this->mDb->connect()->commit(); 

        return [
            "status" => 200,
            "message" => empty($temp['id']) ? "Level added successfully" : "Level updated successfully",
        ];
    } catch (Exception $e) {
        $this->mDb->connect()->rollBack(); 
        return [
            "status" => 500,
            "message" => "Error: " . $e->getMessage(),
        ];
    }
}

function getOneLevel($id) {
    $sql = "SELECT * FROM `user_levels` WHERE `id` = :id";

    try {
        $this->mDb->connect()->beginTransaction();

        $stmt = $this->mDb->connect()->prepare($sql);
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);
        $stmt->execute();

        $result = $stmt->fetch(PDO::FETCH_ASSOC);

        $this->mDb->connect()->commit();

        return $result;
    } catch (PDOException $e) {
        $this->mDb->connect()->rollBack();

        error_log("PDOException: " . $e->getMessage());

        return [
            "status" => 500,
            "message" => "Error fetching the level: " . $e->getMessage(),
        ];
    }
}

public function deleteLevel($ids) {
    if (empty($ids) || !is_array($ids)) {
        return [
            "status" => 400,
            "message" => "Invalid input. Please provide an array of IDs."
        ];
    }

    try {
        $pdo = $this->mDb->connect();
        $pdo->beginTransaction();

        // Step 1: Check if the IDs exist in the database
        $placeholders = implode(',', array_fill(0, count($ids), '?'));
        $sqlCheck = "SELECT `id` FROM `user_levels` WHERE `id` IN ($placeholders)";
        $stmtCheck = $pdo->prepare($sqlCheck);

        foreach ($ids as $index => $id) {
            $stmtCheck->bindValue($index + 1, $id, PDO::PARAM_INT);
        }

        $stmtCheck->execute();
        $existingIds = $stmtCheck->fetchAll(PDO::FETCH_COLUMN);

        // Step 2: Check if all provided IDs exist in the database
        $nonExistingIds = array_diff($ids, $existingIds);
        if (!empty($nonExistingIds)) {
            $nonExistingIdsString = implode(', ', $nonExistingIds);
            return [
                "status" => 404,
                "message" => "The following IDs do not exist in the database: $nonExistingIdsString"
            ];
        }

        // Step 3: Delete the levels
        $sqlDelete = "DELETE FROM `user_levels` WHERE `id` IN ($placeholders)";
        $stmtDelete = $pdo->prepare($sqlDelete);

        foreach ($ids as $index => $id) {
            $stmtDelete->bindValue($index + 1, $id, PDO::PARAM_INT);
        }

        if ($stmtDelete->execute()) {
            $pdo->commit();
            return [
                "status" => 200,
                "message" => "Levels deleted successfully."
            ];
        } else {
            $pdo->rollBack();
            return [
                "status" => 500,
                "message" => "Failed to delete levels."
            ];
        }
    } catch (PDOException $e) {
        $pdo->rollBack();
        error_log("PDOException: " . $e->getMessage());

        return [
            "status" => 500,
            "message" => "Error occurred while deleting levels: " . $e->getMessage()
        ];
    }
}






}?>