<?php

$langObj = new languages();

class languages
{

    var $mDb;
    var $mConfig;

    function __construct()
    {
        global $Config;
        $this->mDb = new iplus();
        $this->mConfig = $Config;
    }

    function getAllLanguages($aStart, $aLimit, $sort, $type, $searchName)
    {
        try {
            $this->mDb->connect()->beginTransaction();
    
            $sql = "SELECT lan.id, lan.name, lan.code, lan.date_added, lan.file , lan.added_by 
                    FROM `languages` lan WHERE lan.id > 0";
    
            if ($searchName) {
                $sql .= " AND lan.name LIKE :searchName";
            }
            $sql .= " ORDER BY lan.{$sort} {$type}";
    
            if ($aLimit) {
                $sql .= " LIMIT :aStart, :aLimit";
            }

            $stmt = $this->mDb->connect()->prepare($sql);
    
            if ($searchName) {
                $stmt->bindValue(':searchName', '%' . $searchName . '%', PDO::PARAM_STR);
            }
            $stmt->bindValue(':aStart', $aStart, PDO::PARAM_INT);
            $stmt->bindValue(':aLimit', $aLimit, PDO::PARAM_INT);
    
            $stmt->execute();
    
            $data = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
            $this->mDb->connect()->commit();
    
            return $data;
    
        } catch (PDOException $e) {
            $this->mDb->connect()->rollBack();
    
            return [
                "status" => 500,
                "message" => "An error occurred: " . $e->getMessage()
            ];
        }
    }
    
    function getSearchLanguagesCount($searchName)
{
    try {
        $this->mDb->connect()->beginTransaction();

        $sql = "SELECT COUNT(`id`) as 'count' FROM `languages` WHERE `id` > 0";

        if ($searchName) {
            $sql .= " AND `name` LIKE :searchName";
        }
        $stmt = $this->mDb->connect()->prepare($sql);

        if ($searchName) {
            $stmt->bindValue(':searchName', '%' . $searchName . '%', PDO::PARAM_STR);
        }
        $stmt->execute();

        $result = $stmt->fetch(PDO::FETCH_ASSOC);

        $this->mDb->connect()->commit();

        return $result;

    } catch (PDOException $e) {
        $this->mDb->connect()->rollBack();

        return [
            "status" => 500,
            "message" => "An error occurred: " . $e->getMessage()
        ];
    }
}




    function addEditLanguage($request)
    {
        // Validate that 'added_by' is an integer
        if (isset($request['added_by']) && !is_int($request['added_by']) && !ctype_digit($request['added_by'])) {
            return ["status" => 400, "message" => "'added_by' must be an integer"];
        }
    
        try {
            // Start transaction
            $this->mDb->connect()->beginTransaction();
    
            $lang_id = isset($request['id']) ? $request['id'] : null;
            $dateTime = date('Y-m-d H:i:s');
    
            if (!$lang_id) { 
                
                $sql = "INSERT INTO `languages` (`name`, `code`, `file`, `added_by`) 
                        VALUES (:name, :code, :file, :added_by)";
                $stmt = $this->mDb->connect()->prepare($sql);
                $stmt->bindParam(':name', $request['name'], PDO::PARAM_STR);
                $stmt->bindParam(':code', $request['code'], PDO::PARAM_STR);
                $stmt->bindParam(':file', $request['file'], PDO::PARAM_STR);  
                $stmt->bindParam(':added_by', $request['added_by'], PDO::PARAM_INT);
                $stmt->execute();
                $this->mDb->connect()->commit();
    
                return [
                    "status" => 200,
                    "message" => "Language added successfully."
                ];
    
            } else {
                $sql = "UPDATE `languages` SET 
                        `name` = :name, `code` = :code, `added_by` = :added_by";
                $stmt = $this->mDb->connect()->prepare($sql);
                $stmt->bindParam(':name', $request['name'], PDO::PARAM_STR);
                $stmt->bindParam(':code', $request['code'], PDO::PARAM_STR);
                $stmt->bindParam(':added_by', $request['added_by'], PDO::PARAM_INT);
    
                // Check if there is a new image
                if (isset($request['file']) && $request['file']) {
                    // Retrieve the old image
                    $img_query = "SELECT `file` FROM `languages` WHERE `id` = :id";
                    $img_stmt = $this->mDb->connect()->prepare($img_query);
                    $img_stmt->bindParam(':id', $lang_id, PDO::PARAM_INT);
                    $img_stmt->execute();
                    $img_result = $img_stmt->fetch(PDO::FETCH_ASSOC);
                    $old_img = $_SERVER['DOCUMENT_ROOT'] . '/' . $this->mConfig['uploads_path'] . 'languages/' . $img_result['file'];
    
                    // Delete old image if it exists
                    if (file_exists($old_img)) {
                        @unlink($old_img);
                    }
    
                    // Update new image
                    $sql .= ", `file` = :file";
                    $stmt = $this->mDb->connect()->prepare($sql);
                    $stmt->bindParam(':file', $request['file'], PDO::PARAM_STR);
                }
    
                $sql .= " WHERE `id` = :id";
                $stmt->bindParam(':id', $lang_id, PDO::PARAM_INT);
                $stmt->execute();
    
                $this->mDb->connect()->commit();
    
                return [
                    "status" => 200,
                    "message" => "Language updated successfully."
                ];
            }
    
        } catch (PDOException $e) {
            // Rollback transaction on error
            $this->mDb->connect()->rollBack();
    
            // Handle file deletion if an error occurs
            if (isset($request['file']) && $request['file']) {
                $erroredImg = $_SERVER['DOCUMENT_ROOT'] . '/' . $this->mConfig['uploads_path'] . 'languages/' . $request['file'];
                if (file_exists($erroredImg)) {
                    unlink($erroredImg);
                }
            }
    
            return [
                "status" => 500,
                "message" => "An error occurred: " . $e->getMessage()
            ];
        }
    }
    

    function getOneLanguage($id)
    {
        try {
            $this->mDb->connect()->beginTransaction();
    
            $sql = "SELECT * FROM `languages` WHERE `id` = :id";
            $stmt = $this->mDb->connect()->prepare($sql);
            $stmt->bindParam(':id', $id, PDO::PARAM_INT);
            $stmt->execute();
    
            $data = $stmt->fetch(PDO::FETCH_ASSOC);
    
            $this->mDb->connect()->commit();
            return [
                "status" => 200,
                "message" => $data
            ];
    
        } catch (PDOException $e) {
            $this->mDb->connect()->rollBack();
    
            return [
                "status" => 500,
                "message" => "An error occurred: " . $e->getMessage()
            ];
        }
    }
    

    function deleteLanguage($ids)
{
    $res = false;
    $deltedImages = 0;
    $this->mDb->connect()->beginTransaction();

    try {
        $sql = "DELETE FROM `languages` WHERE `id` = :ids";

        foreach ($ids as $id) {
            $query = "SELECT `file` FROM `languages` WHERE `id` = :id";
            $stmt = $this->mDb->connect()->prepare($query);
            $stmt->bindParam(':id', $id, PDO::PARAM_INT);
            $stmt->execute();

            $result = $stmt->fetch(PDO::FETCH_ASSOC);

            if ($result) {
                $old_img = $_SERVER['DOCUMENT_ROOT'] . '/' . $this->mConfig['uploads_path'] . 'languages/' . $result['file'];
                if (file_exists($old_img)) {
                    @unlink($old_img);
                }
                $stmt = $this->mDb->connect()->prepare($sql);
                $stmt->bindParam(':ids', $id, PDO::PARAM_INT);
                $stmt->execute();

                if ($stmt->rowCount() > 0) {
                    $deltedImages++;
                }
            }
        }

        if ($deltedImages === 0) {
            $this->mDb->connect()->rollBack();

            return [
                "status" => 404,
                "message" => "No Deletion Occurred"
            ];
        }
        $this->mDb->connect()->commit();

        return [
            "status" => 200,
            "message" => 'Deleted successfully'
        ];

    } catch (PDOException $e) {
        $this->mDb->connect()->rollBack();

        return [
            "status" => 500,
            "message" => "An error occurred: " . $e->getMessage()
        ];
    }
}



} ?>