<?php

use GuzzleHttp\Client;
use Symfony\Component\DomCrawler\Crawler;

$currenciesObj = new currencies();

class currencies
{

	var $mDb;
	var $mConfig;
	var $mlang;
    

	function __construct()
	{
		global $Config;
		global $Lang;
		$this->mDb = new iplus();
		$this->mConfig = $Config;
		$this->mlang = $Lang;
     
	}

	function convert_object_to_array($data)
	{

		if (is_object($data)) {
			$data = get_object_vars($data);
		}

		if (is_array($data)) {
			return array_map(__METHOD__, $data);
		} else {
			return $data;
		}	
    }
    

    function fetchCurrencyRate($currency, $token) {
        $apiUrl = "https://egrates.com/api/v1/prices/{$currency}?token={$token}";
    
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $apiUrl);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        
        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        
        if ($httpCode == 200) {
            $data = json_decode($response, true);
            return $data; 
        } else {
            return null; 
        }
    }
    function existBankCode($bankCode){
        // print"". $bankCode .""; die;
        $query = "SELECT COUNT(*) FROM banks WHERE bank_code = :bank_code";
        $stmt = $this->mDb->connect()->prepare($query);
        $stmt->bindParam(':bank_code', $bankCode);
        $stmt->execute();
        $count = $stmt->fetchColumn();
        return $count;
    }
    function saveBankData($bank) {
        $sql = "INSERT INTO banks (bank_code) VALUES (:bank_code) ON DUPLICATE KEY UPDATE id = LAST_INSERT_ID(id)";
        
        try {
            $this->mDb->beginTransaction();
    
            $stmt = $this->mDb->connect()->prepare($sql);
            $stmt->bindParam(':bank_code', $bank['id']);
            $stmt->execute();
    
            $bank_id = $this->mDb->getLastInsertId();
    
            if ($bank_id) {
                $sqlForLang = "INSERT INTO banks_langs (bank_id, lang_code, name) VALUES (:bank_id, :lang_code, :name) ON DUPLICATE KEY UPDATE name = :name";
                $stmtForLang = $this->mDb->connect()->prepare($sqlForLang);
                
                $lang_code_ar = "ar";
                $stmtForLang->bindParam(':bank_id', $bank_id, PDO::PARAM_INT);
                $stmtForLang->bindParam(':lang_code', $lang_code_ar);
                $stmtForLang->bindParam(':name', $bank['name_ar']);
                $stmtForLang->execute();
    
                $lang_code_en = "en";
                $stmtForLang->bindParam(':lang_code', $lang_code_en);
                $stmtForLang->bindParam(':name', $bank['name_en']);
                $stmtForLang->execute();
                
                $this->mDb->commit();
                return ["status" => 200, "message" => "Bank data saved successfully"];
            }
        } catch (PDOException $e) {
            $this->mDb->rollBack();
            return ["status" => 500, "message" => "An error occurred while saving bank data: " . $e->getMessage()];
        }
    }
  
    public function saveBankCurrenciesData($bank) {
        $bank_id = $bank['id']; 
        $currency_code = $bank['currency_code'];
        $buy_price = $bank['buy'];
        $sell_price = $bank['sell'];
        $buy_rate = $bank['buy_diff'];
        $sell_rate = $bank['sell_diff'];

        $sql = "SELECT COUNT(*) FROM banks_currencies WHERE bank_code = :bank_id AND currency_code = :currency_code";
        $stmt = $this->mDb->connect()->prepare($sql);
        $stmt->bindParam(':bank_id', $bank_id, PDO::PARAM_INT);
        $stmt->bindParam(':currency_code', $currency_code, PDO::PARAM_STR);
        $stmt->execute();
        $exists = $stmt->fetchColumn();
    
        if ($exists > 0) {
            $update_sql = "UPDATE banks_currencies 
                           SET buy_price = :buy_price, sell_price = :sell_price, 
                               buy_rate = :buy_rate, sell_rate = :sell_rate
                           WHERE bank_code = :bank_id AND currency_code = :currency_code";
            $update_stmt = $this->mDb->connect()->prepare($update_sql);
            $update_stmt->bindParam(':buy_price', $buy_price, PDO::PARAM_STR);
            $update_stmt->bindParam(':sell_price', $sell_price, PDO::PARAM_STR);
            $update_stmt->bindParam(':buy_rate', $buy_rate, PDO::PARAM_STR);
            $update_stmt->bindParam(':sell_rate', $sell_rate, PDO::PARAM_STR);
            $update_stmt->bindParam(':bank_id', $bank_id, PDO::PARAM_INT);
            $update_stmt->bindParam(':currency_code', $currency_code, PDO::PARAM_STR);
            $update_stmt->execute();
        } else {
            $insert_sql = "INSERT INTO banks_currencies (bank_code, currency_code, buy_price, sell_price, buy_rate, sell_rate)
                           VALUES (:bank_id, :currency_code, :buy_price, :sell_price, :buy_rate, :sell_rate)";
            $insert_stmt = $this->mDb->connect()->prepare($insert_sql);
            $insert_stmt->bindParam(':bank_id', $bank_id, PDO::PARAM_INT);
            $insert_stmt->bindParam(':currency_code', $currency_code, PDO::PARAM_STR);
            $insert_stmt->bindParam(':buy_price', $buy_price, PDO::PARAM_STR);
            $insert_stmt->bindParam(':sell_price', $sell_price, PDO::PARAM_STR);
            $insert_stmt->bindParam(':buy_rate', $buy_rate, PDO::PARAM_STR);
            $insert_stmt->bindParam(':sell_rate', $sell_rate, PDO::PARAM_STR);
            $insert_stmt->execute();
        }
    }
    

    


    
    
}
