<?php

$commentsObj = new comments();

class comments
{

    var $mDb;
    var $mConfig;
    var $mlang;


    function __construct()
    {
        global $Config;
        global $Lang;
        $this->mDb = new iplus();
        $this->mConfig = $Config;
        $this->mlang = $Lang;
    }

    function convert_object_to_array($data)
    {

        if (is_object($data)) {
            $data = get_object_vars($data);
        }

        if (is_array($data)) {
            return array_map(__METHOD__, $data);
        } else {
            return $data;
        }
    }

    public function getArticleWithDetails($id_article, $aStart = 0, $aLimit = 10){
        try {
            $id_article = intval($id_article);
            $aStart = max(0, intval($aStart));
            $aLimit = max(1, intval($aLimit));

            if ($id_article <= 0) {
                return ['status' => 400, 'message' => 'Invalid article ID'];
            }

            $db = $this->mDb->connect();

            // ✅ جلب بيانات المقال الأساسية
            $stmt = $db->prepare("SELECT 
            a.id,
            a.status,
            a.image,
            a.sort,
            a.id_user,
            a.date_added,
            al.title,
            al.content
        FROM articles a
        LEFT JOIN articles_langs al ON al.id_article = a.id 
        WHERE a.id = :id
        ");
            $stmt->execute([':id' => $id_article]);
            $article = $stmt->fetch(PDO::FETCH_ASSOC);

            if (!$article) {
                return ['status' => 404, 'message' => 'Article not found'];
            }

            $countStmt = $db->prepare("
            SELECT COUNT(*) 
            FROM comments 
            WHERE id_article = :id_article  AND status = 'active'
        ");
            $countStmt->execute([':id_article' => $id_article]);
            $total = $countStmt->fetchColumn();

            // ✅ جلب الكومنتات الأساسية فقط مع بيانات المستخدم
            $stmt = $db->prepare("SELECT c.id, c.id_user, c.content, c.parent_id, c.date_added, u.full_name AS user_name
            FROM comments c
            LEFT JOIN users u ON u.id = c.id_user
            WHERE c.id_article = :id_article AND c.status = 'active'
            ORDER BY c.date_added ASC
            LIMIT :aStart, :aLimit
        ");
            $stmt->bindParam(':id_article', $id_article, PDO::PARAM_INT);
            $stmt->bindParam(':aStart', $aStart, PDO::PARAM_INT);
            $stmt->bindParam(':aLimit', $aLimit, PDO::PARAM_INT);
            $stmt->execute();
            $comments = $stmt->fetchAll(PDO::FETCH_ASSOC);

            // ✅ جلب الردود لكل تعليق أساسي
            foreach ($comments as &$comment) {
                $stmtReply = $db->prepare("SELECT c.id, c.id_user, c.content, c.parent_id, c.date_added, u.full_name AS user_name
                FROM comments c
                LEFT JOIN users u ON u.id = c.id_user
                WHERE c.parent_id = :parent_id AND c.status = 'active'
                ORDER BY c.date_added ASC
                LiMIT 5
            ");
                $stmtReply->execute([':parent_id' => $comment['id']]);
                $comment['replies'] = $stmtReply->fetchAll(PDO::FETCH_ASSOC);
            }

            // ✅ تجميع البيانات النهائية
            return [
                'status' => 200,
                'article' => $article,
                'comments' => $comments,
                'total_comments' => intval($total),
                'pagination' => [
                    'start' => $aStart,
                    'limit' => $aLimit,
                    'has_more' => ($aStart + $aLimit) < $total
                ]
            ];
        } catch (PDOException $e) {
            return [
                'status' => 500,
                'message' => 'Database error: ' . $e->getMessage()
            ];
        }
    }

public function getComments($id_article, $aStart = 0, $aLimit = 10, $parent_id = null)
{
    try {
        $id_article = intval($id_article);
        $parent_id = isset($parent_id) ? intval($parent_id) : null;
        $aStart = max(0, intval($aStart));
        $aLimit = max(1, intval($aLimit));

        if ($id_article <= 0) {
            return ['status' => 400, 'message' => 'Invalid article ID'];
        }

        $db = $this->mDb->connect();

        if ($parent_id !== null) {
            // ✅ تحقق من وجود التعليق الأب
            $checkStmt = $db->prepare("SELECT COUNT(*) FROM comments WHERE parent_id = :parent_id AND id_article = :id_article AND status = 'active'");
            $checkStmt->execute([
                ':parent_id' => $parent_id,
                ':id_article' => $id_article
            ]);

            if ($checkStmt->fetchColumn() == 0) {
                return ['status' => 404, 'message' => 'no replies found for this comment'];
            }

            // ✅ عدد الردود
            $countStmt = $db->prepare("SELECT COUNT(*) FROM comments WHERE parent_id = :parent_id AND id_article = :id_article AND status = 'active'");
            $countStmt->execute([':parent_id' => $parent_id,':id_article' => $id_article]);
            $total = $countStmt->fetchColumn();

            // ✅ جلب الردود باستخدام LIMIT العادي
            $stmt = $db->prepare("SELECT c.id, c.id_user, c.content, c.parent_id, c.date_added, u.full_name AS user_name
                FROM comments c
                LEFT JOIN users u ON u.id = c.id_user
                WHERE c.parent_id = :parent_id AND id_article= :id_article AND c.status = 'active'
                ORDER BY c.date_added ASC
                LIMIT $aStart, $aLimit
            ");
            $stmt->execute([':parent_id' => $parent_id,':id_article' => $id_article]);
            $replies = $stmt->fetchAll(PDO::FETCH_ASSOC);

            return [
                'status' => 200,
                'replies' => $replies,
                'total_comments' => intval($total),
                'pagination' => [
                    'start' => $aStart,
                    'limit' => $aLimit,
                    'has_more' => ($aStart + $aLimit) < $total
                ]
            ];
        }

        // ✅ جلب التعليقات الأساسية
        $countStmt = $db->prepare("SELECT COUNT(*) FROM comments WHERE id_article = :id_article  AND status = 'active'");
        $countStmt->execute([':id_article' => $id_article]);
        $total = $countStmt->fetchColumn();

        $stmt = $db->prepare("
            SELECT c.id, c.id_user, c.content, c.parent_id, c.date_added, u.full_name AS user_name
            FROM comments c
            LEFT JOIN users u ON u.id = c.id_user
            WHERE c.id_article = :id_article AND c.status = 'active' AND c.parent_id IS NULL
            ORDER BY c.date_added ASC
            LIMIT $aStart, $aLimit
        ");
        $stmt->execute([':id_article' => $id_article]);
        $comments = $stmt->fetchAll(PDO::FETCH_ASSOC);

        return [
            'status' => 200,
            'comments' => $comments,
            'total_comments' => intval($total),
            'pagination' => [
                'start' => $aStart,
                'limit' => $aLimit,
                'has_more' => ($aStart + $aLimit) < $total
            ]
        ];
    } catch (PDOException $e) {
        return [
            'status' => 500,
            'message' => 'Database error: ' . $e->getMessage()
        ];
    }
}






    public function deleteComments($ids)
    {
        $deleted = 0;
        $this->mDb->connect()->beginTransaction();

        try {
            $sqlDelete = "DELETE FROM comments WHERE id = :id";

            foreach ($ids as $id) {
                $id = intval($id);
                if ($id <= 0) continue;

                $stmtCheck = $this->mDb->connect()->prepare("SELECT id FROM comments WHERE id = :id");
                $stmtCheck->bindParam(':id', $id, PDO::PARAM_INT);
                $stmtCheck->execute();

                if ($stmtCheck->fetch()) {
                    $stmtDelete = $this->mDb->connect()->prepare($sqlDelete);
                    $stmtDelete->bindParam(':id', $id, PDO::PARAM_INT);
                    $stmtDelete->execute();

                    if ($stmtDelete->rowCount() > 0) {
                        $deleted++;
                    }
                }
            }

            if ($deleted === 0) {
                $this->mDb->connect()->rollBack();
                return [
                    "status" => 404,
                    "message" => "لم يتم حذف أي تعليق"
                ];
            }

            $this->mDb->connect()->commit();
            return [
                "status" => 200,
                "message" => "comments deleted successfully",
                "deleted_count" => $deleted
            ];
        } catch (PDOException $e) {
            $this->mDb->connect()->rollBack();
            return [
                "status" => 500,
                "message" => "حدث خطأ أثناء الحذف: " . $e->getMessage()
            ];
        }
    }
}
