<?php
$comment_reactionsObj = new comment_reactions();

class comment_reactions
{


    var $mDb;
    var $mConfig;
    var $mlang;

    function __construct()
    {
        global $Config;
        global $Lang;
        $this->mDb = new iplus();
        $this->mConfig = $Config;
        $this->mlang = $Lang;
    }

    function convert_object_to_array($data)
    {
        if (is_object($data)) {
            $data = get_object_vars($data);
        }

        if (is_array($data)) {
            return array_map(__METHOD__, $data);
        } else {
            return $data;
        }
    }



public function likeOrDislikeComment($comment_id, $user_id, $reaction_type)
{
    try {
        $comment_id = intval($comment_id);
        $user_id = intval($user_id);
        // $allowedTypes = ['like', 'dislike'];



        $db = $this->mDb->connect();

        // التحقق إذا كان نفس التفاعل موجود بالفعل
        $stmt = $db->prepare("SELECT * FROM mode_reactions 
                        WHERE mode_id = :mode_id AND user_id = :user_id AND reaction_type = :reaction_type");
        $stmt->execute([
            ':mode_id' => $comment_id,
            ':user_id' => $user_id,
            ':reaction_type' => $reaction_type
        ]);

        $existing = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($existing) {
            // إذا كان التفاعل موجود بالفعل بنفس النوع → حذف
            $this->removeUserReaction($comment_id, $user_id, $reaction_type);
            return ['status' => 200, 'message' => 'تم حذف التفاعل السابق'];
        }

        // إذا لم يكن موجود بنفس النوع → إضافة أو تعديل التفاعل
        $stmt = $db->prepare("INSERT INTO mode_reactions (mode_id, user_id, reaction_type)
                            VALUES (:mode_id, :user_id, :reaction_type)
                            ON DUPLICATE KEY UPDATE reaction_type = :reaction_type");

        $stmt->execute([
            ':mode_id' => $comment_id,
            ':user_id' => $user_id,
            ':reaction_type' => $reaction_type
        ]);

        return ['status' => 200, 'message' => 'تم حفظ التفاعل بنجاح'];
        
    } catch (PDOException $e) {
        return ['status' => 500, 'message' => 'Database Error: ' . $e->getMessage()];
    }
}



    public function getCommentReactionsCount($comment_id)
    {
        try {
            $comment_id = intval($comment_id);
            $sql = "SELECT reaction_type, COUNT(*) as total 
                FROM mode_reactions 
                WHERE mode_id = ? 
                GROUP BY reaction_type";

            $stmt = $this->mDb->connect()->prepare($sql);
            $stmt->execute([$comment_id]);
            $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

            $result = ['like' => 0, 'dislike' => 0];
            foreach ($rows as $row) {
                $type = $row['reaction_type'];
                $result[$type] = intval($row['total']);
            }

            return ['status' => 200, 'data' => $result];
        } catch (PDOException $e) {
            return ['status' => 500, 'message' => 'Database Error: ' . $e->getMessage()];
        }
    }

    public function getUserReactionForComment($comment_id, $user_id)
    {
        try {
            $stmt = $this->mDb->connect()->prepare(
                "SELECT reaction_type FROM mode_reactions 
            WHERE mode_id = ? AND user_id = ?"
            );
            $stmt->execute([$comment_id, $user_id]);
            $reaction = $stmt->fetchColumn();

            if ($reaction) {
                return ['status' => 200, 'reaction_type' => $reaction];
            } else {
                return ['status' => 204, 'reaction_type' => null];
            }
        } catch (PDOException $e) {
            return ['status' => 500, 'message' => 'Database Error: ' . $e->getMessage()];
        }
    }

    public function removeUserReaction($comment_id, $user_id,$reaction_type)
    {
        try {
            $stmt = $this->mDb->connect()->prepare(
                "DELETE FROM mode_reactions 
            WHERE mode_id = ? AND user_id = ? AND reaction_type = ?"
            );
            $stmt->execute([$comment_id, $user_id, $reaction_type]);

            return ['status' => 200, 'message' => 'تم حذف التفاعل بنجاح'];
        } catch (PDOException $e) {
            return ['status' => 500, 'message' => 'Database Error: ' . $e->getMessage()];
        }
    }
}
