<?php

$bannersObj = new banners();

class banners
{

	var $mDb;
	var $mConfig;
	var $mlang;
    

	function __construct()
	{
		global $Config;
		global $Lang;
		$this->mDb = new iplus();
		$this->mConfig = $Config;
		$this->mlang = $Lang;
     
	}

	function convert_object_to_array($data)
	{

		if (is_object($data)) {
			$data = get_object_vars($data);
		}

		if (is_array($data)) {
			return array_map(__METHOD__, $data);
		} else {
			return $data;
		}
	}

    function getAllBanner($aStart, $aLimit, $sort, $type, $searchName, $searchBankId, $searchBannerId) {
        $lang_code = LANGUAGE;
        
        if ($searchBankId) {
            $validationSql = "SELECT COUNT(*) AS count FROM banks WHERE id = :searchBankId AND is_deleted = 0";
            try {
                $validationStmt = $this->mDb->connect()->prepare($validationSql);
                $validationStmt->bindParam(':searchBankId', $searchBankId, PDO::PARAM_INT);
                $validationStmt->execute();
                $validationResult = $validationStmt->fetch(PDO::FETCH_ASSOC);
    
                if ($validationResult['count'] == 0) {
                    return ['error' => "Bank ID {$searchBankId} does not exist in the banks table."];
                }
            } catch (PDOException $e) {
                error_log("PDOException in validating searchBankId: " . $e->getMessage());
                return ['error' => "An error occurred while validating the Bank ID."];
            }
        }
    
        // Main query
        $sql = "SELECT b.*, bl.name, bl.description	
                FROM banners b
                LEFT JOIN banners_langs bl ON b.id = bl.banner_id AND bl.lang_code = :lang_code
                LEFT JOIN bank_banners bb ON b.id = bb.banner_id 
                WHERE b.is_deleted = 0 ";
    
        if ($searchName) {
            $sql .= " AND bl.name LIKE :searchName"; 
        }
        if ($searchBankId) {
            $sql .= " AND bb.bank_id = :searchBankId";
        }
        if ($searchBannerId) {
            $sql .= " AND b.id = :searchBannerId";
        }
        if ($sort == 'name') {
            $sql .= " ORDER BY bl.name {$type}";
        } else {
            $sql .= " ORDER BY b.{$sort} {$type}";
        }
        if ($aLimit) {
            $sql .= " LIMIT :aStart, :aLimit";
        }
        // echo ($sql);die();
        try {
            $this->mDb->connect()->beginTransaction();
    
            $stmt = $this->mDb->connect()->prepare($sql);
            $stmt->bindParam(':lang_code', $lang_code, PDO::PARAM_STR);
    
            if ($searchName) {
                $stmt->bindParam(':searchName', $searchName, PDO::PARAM_STR);
            }
            if ($searchBannerId) {
                $stmt->bindParam(':searchBannerId', $searchBannerId, PDO::PARAM_INT);
            }
            if ($searchBankId) {
                $stmt->bindParam(':searchBankId', $searchBankId, PDO::PARAM_INT);
            }
    
            if ($aLimit) {
                $stmt->bindParam(':aStart', $aStart, PDO::PARAM_INT);
                $stmt->bindParam(':aLimit', $aLimit, PDO::PARAM_INT);
            }
    
            $stmt->execute();
            $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
            $this->mDb->connect()->commit();
            return $results;
    
        } catch (PDOException $e) {
            $this->mDb->connect()->rollBack();
            error_log("PDOException in getAllPages: " . $e->getMessage());
            return array();
        }
    }
    function getSearchBannerCount($searchName, $searchBankId, $searchBannerId) {
        $lang_code = LANGUAGE;
        $sql = "SELECT COUNT(b.`id`) as result_count 
                FROM banners b
                LEFT JOIN banners_langs bl ON b.id = bl.banner_id AND bl.lang_code = :lang_code
                LEFT JOIN bank_banners bb ON b.id = bb.banner_id 
                WHERE b.is_deleted = 0 ";
    
        if (!empty($searchName)) {
            $sql .= " AND bl.name LIKE :searchName";
        }
        if ($searchBannerId) {
            $sql .= " AND b.id = :searchBannerId";
        }
        if (!empty($searchBankId)) {
            $sql .= " AND bb.bank_id LIKE :searchBankId";
        }
    
        try {
            $this->mDb->connect()->beginTransaction();
    
            $stmt = $this->mDb->connect()->prepare($sql);
            $stmt->bindParam(':lang_code', $lang_code, PDO::PARAM_STR);
    
            if (!empty($searchName)) {
                $stmt->bindParam(':searchName', $searchName, PDO::PARAM_STR);
            }
            if ($searchBannerId) {
                $stmt->bindParam(':searchBannerId', $searchBannerId, PDO::PARAM_INT);
            }
            if (!empty($searchBankId)) {
                $stmt->bindParam(':searchBankId', $searchBankId, PDO::PARAM_INT);
            }
    
            $stmt->execute();
            $resultCount = $stmt->fetchColumn();
    
            $this->mDb->connect()->commit();
            return $resultCount;
    
        } catch (PDOException $e) {
            $this->mDb->connect()->rollBack();
            error_log("PDOException in getSearchBanksCount: " . $e->getMessage());
            return 0;
        }
    }
    function getBankBanners($bankId) {
        try {
           
            $this->mDb->beginTransaction();
    
            $sql = "SELECT b.id AS banner_id
                    FROM bank_banners bb
                    JOIN banners b ON bb.banner_id = b.id
                    WHERE bb.bank_id = :bank_id;
                        ";
    
            $stmt = $this->mDb->connect()->prepare($sql);
            $stmt->bindParam(':bank_id', $bankId, PDO::PARAM_INT);
            // $stmt->bindParam(':lang_code', $lang_code, PDO::PARAM_STR);

    
            if ($stmt->execute()) {
                $banners = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
                if (!$banners) {
                    throw new Exception("No Banners found for bank ID $bankId.");
                }
            } else {
                throw new Exception("Error executing Banners SQL: " . implode(", ", $stmt->errorInfo()));
            }
    
            $result = [];
    
            foreach ($banners as $banner) {
                $bannerId = $banner['banner_id'];
    
                $sqlLangs = "SELECT bl.lang_code, bl.name, bl.description
                             FROM banners_langs bl 
                             WHERE bl.banner_id = :banner_id";
    
                $stmtLangs = $this->mDb->connect()->prepare($sqlLangs);
                $stmtLangs->bindParam(':banner_id', $bannerId, PDO::PARAM_INT);
    
                if ($stmtLangs->execute()) {
                    $bannerLangs = $stmtLangs->fetchAll(PDO::FETCH_ASSOC);
    
                    $banner['langs'] = $bannerLangs;
                    $result['banners'][] = $banner;
                } else {
                    throw new Exception("Error executing atms_langs SQL for atm ID $bannerId: " . implode(", ", $stmtLangs->errorInfo()));
                }
            }
    
            $this->mDb->commit();
    
            return $result ;
    
        } catch (Exception $e) {
            $this->mDb->rollBack();
            return ["status" => 500, "message" => "An error occurred: " . $e->getMessage()];
        }
    }
    function getOneBanner($id) {
        try {
            $this->mDb->beginTransaction();
    
            $sql = "SELECT b.*
                    FROM `banners` b WHERE b.`id` = :id";
    
            $stmt = $this->mDb->connect()->prepare($sql);
            $stmt->bindParam(':id', $id, PDO::PARAM_INT);
    
            if ($stmt->execute()) {
                $result = $stmt->fetch(PDO::FETCH_ASSOC);
                if (!$result) {
                    throw new Exception("Banner with ID $id not found.");
                }
            } else {
                throw new Exception("Error executing the main SQL statement: " . implode(", ", $stmt->errorInfo()));
            }
    
            $sqlLangs = "SELECT bl.`lang_code`, bl.`name`,bl.`description`
                         FROM `banners_langs` bl WHERE bl.`banner_id` = :id";
            $stmtLangs = $this->mDb->connect()->prepare($sqlLangs);
            $stmtLangs->bindParam(':id', $id, PDO::PARAM_INT);
            
            if ($stmtLangs->execute()) {
                $result['langs'] = $stmtLangs->fetchAll(PDO::FETCH_ASSOC);
            } else {
                throw new Exception("Error executing the languages SQL statement: " . implode(", ", $stmtLangs->errorInfo()));
            }
            $sqlBankBanner = "SELECT bb.bank_id
            FROM `bank_banners` bb WHERE bb.`banner_id` = :id";
            $stmtBankBanner = $this->mDb->connect()->prepare($sqlBankBanner);
            $stmtBankBanner->bindParam(':id', $id, PDO::PARAM_INT);

            if ($stmtBankBanner->execute()) {
            $result['Banks'] = $stmtBankBanner->fetchAll(PDO::FETCH_ASSOC);
            } else {
            throw new Exception("Error executing the banks banners SQL statement: " . implode(", ", $stmtBankBanner->errorInfo()));
            }
            // Commit the transaction after both queries are successful
            $this->mDb->commit();
    
            return $result;
        } catch (Exception $e) {
            // Rollback in case of any error
            $this->mDb->rollBack();
            return ["status" => 500, "message" => "An error occurred: " . $e->getMessage()];
        }
    }
    function addEditBanner($request) {
        if (isset($request['added_by']) && !is_int($request['added_by']) && !ctype_digit($request['added_by'])) {
            return ["status" => 400, "message" => "'added_by' must be an integer"];
        }
    
        unset($request['action']);
        $dataLangObj = json_decode($request['langs']);
        $newDataLangObj = $this->convert_object_to_array($dataLangObj);
        $dateTime = date('Y-m-d H:i:s');
    
        if (!($request['id'])) {
            $sql = "INSERT INTO banners SET added_by = :added_by, date_added = :dateTime";
            $sql .= ", img = :img"; 
            $sql .= ", url = :url";
            $sql .= ", sort = :sort";
            $sql .= ", status = :status";
           
    
            try {
                $this->mDb->beginTransaction();
                $stmt = $this->mDb->connect()->prepare($sql);
    
                $stmt->bindParam(':added_by', $request['added_by'], PDO::PARAM_INT);
                $stmt->bindParam(':dateTime', $dateTime);
                $stmt->bindParam(':img', $request['file']);  
                $stmt->bindParam(':url', $request['url']);
                $stmt->bindParam(':sort', $request['sort'], PDO::PARAM_INT);
                $stmt->bindParam(':status', $request['status'], PDO::PARAM_INT);
                
    
                $stmt->execute();
    
                $last_id = $this->mDb->getLastInsertId();
                foreach ($newDataLangObj as $key => $value) {
                    $sqlForLang = "INSERT INTO banners_langs (banner_id, lang_code, name, description) VALUES (:banner_id, :lang_code, :name, :description)";
                    $stmtForLang = $this->mDb->connect()->prepare($sqlForLang);
                    
                    $stmtForLang->bindParam(':banner_id', $last_id, PDO::PARAM_INT);
                    $stmtForLang->bindParam(':lang_code', $value['lang_code']);
                    $stmtForLang->bindParam(':name', $value['name'], PDO::PARAM_STR);
                    $stmtForLang->bindParam(':description', $value['description'], PDO::PARAM_STR);
                    $stmtForLang->execute();
                }
                
                
                if (!empty($request['bank_banners'])) {
                    $bankBanners = json_decode($request['bank_banners']);
                    $newDataBankObj = $this->convert_object_to_array($bankBanners);
                    foreach ($newDataBankObj as $bankBanner) {
                        $bankId = ($bankBanner['place'] === 'main_page') ? null : $bankBanner['bank_id'];
                
                        $sqlForBankBanner = "INSERT INTO bank_banners (banner_id, bank_id, place) VALUES (:banner_id, :bank_id, :place)";
                        $stmtForBankBanner = $this->mDb->connect()->prepare($sqlForBankBanner);
                
                        $stmtForBankBanner->bindParam(':banner_id', $last_id, PDO::PARAM_INT);
                        
                        if ($bankId === null) {
                            $stmtForBankBanner->bindValue(':bank_id', null, PDO::PARAM_NULL);
                        } else {
                            $stmtForBankBanner->bindValue(':bank_id', $bankId, PDO::PARAM_INT);
                        }
                
                        $stmtForBankBanner->bindParam(':place', $bankBanner['place'], PDO::PARAM_STR);
                
                        $stmtForBankBanner->execute();
                    }
                }
                
                
    
                $this->mDb->commit();
                return ["status" => 200, "message" => "Banner added successfully"];
            } catch (PDOException $e) {
                $this->mDb->rollBack();
                if (isset($request['file'])) {
                    $errorImage = $_SERVER['DOCUMENT_ROOT'] . '/' . $this->mConfig['uploads_path'] . 'banners/' . $request['file'];
                    if (file_exists($errorImage)) unlink($errorImage);
                }
                return ["status" => 500, "message" => "An error occurred"];
            }
        } else {
            $sql = "UPDATE banners SET date_added = :date_added, img = :img, url = :url, sort = :sort, 
                    status = :status, is_deleted = :is_deleted, added_by = :added_by WHERE id = :id";
    
            try {
                $this->mDb->beginTransaction();
    
                if (isset($request['file'])) {
                    $sqlForImage = "SELECT img FROM banners WHERE id = :id";
                    $stmtForImage = $this->mDb->connect()->prepare($sqlForImage);
                    $stmtForImage->bindParam(':id', $request['id'], PDO::PARAM_INT);
                    $stmtForImage->execute();
                    $PageImage = $stmtForImage->fetch(PDO::FETCH_COLUMN);
                }
    
                if (isset($request['status'])) {
                    $sql .= " status = :status";
                }
                if (isset($request['file'])) {
                    $sql .= isset($request['status']) ? ", img = :img" : " img = :img";  
                }
                if (isset($request['added_by'])) {
                    $sql .= (isset($request['status']) || isset($request['file'])) ? ", added_by = :added_by" : " added_by = :added_by";
                }
    
                $sql .= " WHERE id = :id";
    
                $stmt = $this->mDb->connect()->prepare($sql);
                if (isset($request['status'])) $stmt->bindParam(':status', $request['status'], PDO::PARAM_INT);
                if (isset($request['file'])) $stmt->bindParam(':img', $request['file']);
                if (isset($request['added_by'])) $stmt->bindParam(':added_by', $request['added_by'], PDO::PARAM_INT);
                $stmt->bindParam(':id', $request['id'], PDO::PARAM_INT);
                $stmt->execute();
    
                foreach ($newDataLangObj as $key => $value) {
                    $sqlForLang = "UPDATE banners_langs SET name = :name, description = :description WHERE banner_id = :banner_id AND lang_code = :lang_code";
                    $stmtForLang = $this->mDb->connect()->prepare($sqlForLang);
                    $stmtForLang->bindParam(':name', $value['name']);
                    $stmtForLang->bindParam(':description', $value['description']);
                    $stmtForLang->bindParam(':banner_id', $request['id'], PDO::PARAM_INT);
                    $stmtForLang->bindParam(':lang_code', $value['lang_code']);
                    $stmtForLang->execute();
                }
    
                if (isset($request['file'])) {
                    $errorImage = $_SERVER['DOCUMENT_ROOT'] . '/' . $this->mConfig['uploads_path'] . 'banners/' . $PageImage;
                    if (file_exists($errorImage)) unlink($errorImage);
                }
    
                $this->mDb->commit();
                return ["status" => 200, "message" => "Banner updated successfully"];
            } catch (PDOException $e) {
                $this->mDb->rollBack();
                if (isset($request['file'])) {
                    $errorImage = $_SERVER['DOCUMENT_ROOT'] . '/' . $this->mConfig['uploads_path'] . 'banners/' . $request['file'];
                    if (file_exists($errorImage)) unlink($errorImage);
                }
                return ["status" => 500, "message" => "An error occurred"];
            }
        }
    }
    function deleteBanner($ids) {
        if (empty($ids) || !is_array($ids)) {
            return [
                "status" => 400,
                "message" => "Invalid input. Please provide an array of IDs."
            ];
        }
    
        try {
            $pdo = $this->mDb->connect();
            $pdo->beginTransaction();
    
            // Prepare to fetch the logos (images) of the banks to delete
            $placeholders = implode(',', array_fill(0, count($ids), '?'));
            $sqlDeleteLangs = "DELETE FROM `banners_langs` WHERE `banner_id` IN ($placeholders)";
            $stmtDeleteLangs = $this->mDb->connect()->prepare($sqlDeleteLangs);
            $stmtDeleteLangs->execute($ids);

            $sqlDeleteBankBanner = "DELETE FROM `bank_banners` WHERE `banner_id` IN ($placeholders)";
            $stmtDeleteBankBanner= $this->mDb->connect()->prepare($sqlDeleteBankBanner);
            $stmtDeleteBankBanner->execute($ids);

            $sqlSelectImages = "SELECT `img` FROM `banners` WHERE `id` IN ($placeholders)";
            $stmtSelectImages = $pdo->prepare($sqlSelectImages);
            $stmtSelectImages->execute($ids);
            $images = $stmtSelectImages->fetchAll(PDO::FETCH_ASSOC);
    
            // Delete the images from the server
            if (!empty($images)) {
                foreach ($images as $image) {
                    $old_img = $_SERVER['DOCUMENT_ROOT'] . '/' . $this->mConfig['uploads_path'] . 'banner/' . $image['img']; // Fixed 'logo' field
                    if (file_exists($old_img)) {
                        @unlink($old_img); // Delete the file silently
                    }
                }
            }
    
            // Check if all the bank IDs exist
            $sqlCheck = "SELECT `id` FROM `banners` WHERE `id` IN ($placeholders)";
            $stmtCheck = $pdo->prepare($sqlCheck);
    
            foreach ($ids as $index => $id) {
                $stmtCheck->bindValue($index + 1, $id, PDO::PARAM_INT);
            }
    
            $stmtCheck->execute();
            $existingIds = $stmtCheck->fetchAll(PDO::FETCH_COLUMN);
    
            // Check for non-existing IDs
            $nonExistingIds = array_diff($ids, $existingIds);
            if (!empty($nonExistingIds)) {
                $nonExistingIdsString = implode(', ', $nonExistingIds);
                return [
                    "status" => 404,
                    "message" => "The following IDs do not exist in the database: $nonExistingIdsString"
                ];
            }
    
            // Perform the deletion
            $sqlDelete = "DELETE FROM `banners` WHERE `id` IN ($placeholders)";
            $stmtDelete = $pdo->prepare($sqlDelete);
    
            foreach ($ids as $index => $id) {
                $stmtDelete->bindValue($index + 1, $id, PDO::PARAM_INT);
            }
    
            if ($stmtDelete->execute()) {
                $pdo->commit();
                return [
                    "status" => 200,
                    "message" => "Bank(s) deleted successfully."
                ];
            } else {
                $pdo->rollBack();
                return [
                    "status" => 500,
                    "message" => "Failed to delete bank(s)."
                ];
            }
        } catch (PDOException $e) {
            $pdo->rollBack();
            error_log("PDOException: " . $e->getMessage());
    
            return [
                "status" => 500,
                "message" => "Error occurred while deleting bank(s): " . $e->getMessage()
            ];
        }
    }

}    