<?php

$banksObj = new banks();

class banks
{

	var $mDb;
	var $mConfig;
	var $mlang;
    

	function __construct()
	{
		global $Config;
		global $Lang;
		$this->mDb = new iplus();
		$this->mConfig = $Config;
		$this->mlang = $Lang;
     
	}

	function convert_object_to_array($data)
	{

		if (is_object($data)) {
			$data = get_object_vars($data);
		}

		if (is_array($data)) {
			return array_map(__METHOD__, $data);
		} else {
			return $data;
		}
	}

    function getAllBanks($aStart, $aLimit, $sort, $type, $searchName) {
        $lang_code = LANGUAGE;
        $sql = "SELECT b.id, b.added_by, b.status, b.sort, b.logo, b.date_added, bl.name
                FROM banks b
                LEFT JOIN banks_langs bl ON b.id = bl.bank_id AND bl.lang_code = :lang_code
                WHERE b.is_deleted = 0 ";
    
        if ($searchName) {
            $sql .= " AND bl.name LIKE :searchName";
        }
        if ($sort == 'name') {
            $sql .= " ORDER BY bl.name {$type}";
        } else {
            $sql .= " ORDER BY b.{$sort} {$type}";
        }
        if ($aLimit) {
            $sql .= " LIMIT :aStart, :aLimit";
        }
        // echo ($sql);die();
        try {
            $this->mDb->connect()->beginTransaction();
    
            $stmt = $this->mDb->connect()->prepare($sql);
            $stmt->bindParam(':lang_code', $lang_code, PDO::PARAM_STR);
    
            if ($searchName) {
                $stmt->bindParam(':searchName', $searchName, PDO::PARAM_STR);
            }
    
            if ($aLimit) {
                $stmt->bindParam(':aStart', $aStart, PDO::PARAM_INT);
                $stmt->bindParam(':aLimit', $aLimit, PDO::PARAM_INT);
            }
    
            $stmt->execute();
            $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
            $this->mDb->connect()->commit();
            return $results;
    
        } catch (PDOException $e) {
            $this->mDb->connect()->rollBack();
            error_log("PDOException in getAllPages: " . $e->getMessage());
            return array();
        }
    }
    
    function getSearchBanksCount($searchName,$lang_code) {
        $sql = "SELECT COUNT(b.`id`) as result_count 
                FROM banks b
                LEFT JOIN banks_langs bl ON b.id = bl.bank_id AND bl.lang_code = :lang_code
                WHERE b.is_deleted = 0 ";
    
        if (!empty($searchName)) {
            $sql .= " AND bl.name LIKE :searchName";
        }
    
        try {
            $this->mDb->connect()->beginTransaction();
    
            $stmt = $this->mDb->connect()->prepare($sql);
            $stmt->bindParam(':lang_code', $lang_code, PDO::PARAM_STR);
    
            if (!empty($searchName)) {
                $stmt->bindParam(':searchName', $searchName, PDO::PARAM_STR);
            }
    
            $stmt->execute();
            $resultCount = $stmt->fetchColumn();
    
            $this->mDb->connect()->commit();
            return $resultCount;
    
        } catch (PDOException $e) {
            $this->mDb->connect()->rollBack();
            error_log("PDOException in getSearchBanksCount: " . $e->getMessage());
            return 0;
        }
    }
    
    function addEditBank($request) {
        // Validate added_by to be an integer
        if (isset($request['added_by']) && !is_int($request['added_by']) && !ctype_digit($request['added_by'])) {
            return ["status" => 400, "message" => "'added_by' must be an integer"];
        }
    
        unset($request['action']);
        $dataLangObj = json_decode($request['langs']);
        // print_r($request['langs']);die;
        $newDataLangObj = $this->convert_object_to_array($dataLangObj);
        $dateTime = date('Y-m-d H:i:s');
    
        if (!($request['id'])) {
            $sql = "INSERT INTO banks SET added_by = :added_by, date_added = :dateTime";
            $sql .= ", status = :status";
            $sql .= ", sort = :sort";
            $sql .= ", logo = :logo";
    
            try {
                $this->mDb->beginTransaction();
                $stmt = $this->mDb->connect()->prepare($sql);
                $stmt->bindParam(':added_by', $request['added_by'], PDO::PARAM_INT);
                $stmt->bindParam(':dateTime', $dateTime);
                $stmt->bindParam(':status', $request['status'], PDO::PARAM_INT);
                $stmt->bindParam(':sort', $request['sort'], PDO::PARAM_INT);
                $stmt->bindParam(':logo', $request['file']);
                $stmt->execute();
    
                $last_id = $this->mDb->getLastInsertId();
                foreach ($newDataLangObj as $key => $value) {
                    $sqlForLang = "INSERT INTO banks_langs (bank_id, lang_code, name) VALUES (:bank_id, :lang_code, :name)";
                    $stmtForLang = $this->mDb->connect()->prepare($sqlForLang);
                    $stmtForLang->bindParam(':bank_id', $last_id, PDO::PARAM_INT);
                    $stmtForLang->bindParam(':lang_code', $value['lang_code']);
                    $stmtForLang->bindParam(':name', $value['name']);
                    $stmtForLang->execute();
                }
    
                $this->mDb->commit();
                return ["status" => 200, "message" => $request];
            } catch (PDOException $e) {
                $this->mDb->rollBack();
                if (isset($request['file'])) {
                    $eroredimg = $_SERVER['DOCUMENT_ROOT'] . '/' . $this->mConfig['uploads_path'] . 'banks/' . $request['file'];
                    if (file_exists($eroredimg)) unlink($eroredimg);
                }
                return ["status" => 500, "message" => "An Error Occurred"];
            }
        } else {
            // Update operation
            $sql = "UPDATE banks SET";
            try {
                $this->mDb->beginTransaction();
    
                // Check if file exists in the request and retrieve the old image
                if (isset($request['file'])) {
                    $sqlForImage = "SELECT logo FROM banks WHERE id = :id";
                    $stmtForImage = $this->mDb->connect()->prepare($sqlForImage);
                    $stmtForImage->bindParam(':id', $request['id'], PDO::PARAM_INT);
                    $stmtForImage->execute();
                    $PageImage = $stmtForImage->fetch(PDO::FETCH_COLUMN);
                }
    
                // Add fields to the SQL query
                if (isset($request['status'])) {
                    $sql .= " status = :status";
                }
                if (isset($request['file'])) {
                    $sql .= isset($request['status']) ? ", logo = :logo" : " logo = :logo";
                }
                if (isset($request['added_by'])) {
                    $sql .= (isset($request['status']) || isset($request['file'])) ? ", added_by = :added_by" : " added_by = :added_by";
                }
    
                // Add WHERE clause
                $sql .= " WHERE id = :id";
    
                // Prepare and execute the SQL query
                $stmt = $this->mDb->connect()->prepare($sql);
                if (isset($request['status'])) $stmt->bindParam(':status', $request['status'], PDO::PARAM_INT);
                if (isset($request['file'])) $stmt->bindParam(':logo', $request['file']);
                if (isset($request['added_by'])) $stmt->bindParam(':added_by', $request['added_by'], PDO::PARAM_INT);
                $stmt->bindParam(':id', $request['id'], PDO::PARAM_INT);
                $stmt->execute();
    
                // Update languages for the bank
                foreach ($newDataLangObj as $key => $value) {
                    $sqlForLang = "UPDATE banks_langs SET name = :name WHERE bank_id = :bankId AND lang_code = :lang_code";
                    $stmtForLang = $this->mDb->connect()->prepare($sqlForLang);
                    $stmtForLang->bindParam(':name', $value['name']);
                    $stmtForLang->bindParam(':bankId', $request['id'], PDO::PARAM_INT);
                    $stmtForLang->bindParam(':lang_code', $value['lang_code']);
                    $stmtForLang->execute();
                }
    
                // If a new file was uploaded, remove the old one
                if (isset($request['file'])) {
                    $eroredimg = $_SERVER['DOCUMENT_ROOT'] . '/' . $this->mConfig['uploads_path'] . 'banks/' . $PageImage;
                    if (file_exists($eroredimg)) unlink($eroredimg);
                }
    
                $this->mDb->commit();
                return ["status" => 200, "message" => "Updated"];
            } catch (PDOException $e) {
                $this->mDb->rollBack();
                if (isset($request['file'])) {
                    $eroredimg = $_SERVER['DOCUMENT_ROOT'] . '/' . $this->mConfig['uploads_path'] . 'banks/' . $request['file'];
                    if (file_exists($eroredimg)) unlink($eroredimg);
                }
                return ["status" => 500, "message" => "An error occurred"];
            }
        }
    }
    function deleteBank($ids) {
        if (empty($ids) || !is_array($ids)) {
            return [
                "status" => 400,
                "message" => "Invalid input. Please provide an array of IDs."
            ];
        }
    
        try {
            $pdo = $this->mDb->connect();
            $pdo->beginTransaction();
    
            // Prepare to fetch the logos (images) of the banks to delete
            $placeholders = implode(',', array_fill(0, count($ids), '?'));
            $sqlDeleteLangs = "DELETE FROM `banks_langs` WHERE `bank_id` IN ($placeholders)";
            $stmtDeleteLangs = $this->mDb->connect()->prepare($sqlDeleteLangs);
            $stmtDeleteLangs->execute($ids);
            $sqlSelectImages = "SELECT `logo` FROM `banks` WHERE `id` IN ($placeholders)";
            $stmtSelectImages = $pdo->prepare($sqlSelectImages);
            $stmtSelectImages->execute($ids);
            $images = $stmtSelectImages->fetchAll(PDO::FETCH_ASSOC);
    
            // Delete the images from the server
            if (!empty($images)) {
                foreach ($images as $image) {
                    $old_img = $_SERVER['DOCUMENT_ROOT'] . '/' . $this->mConfig['uploads_path'] . 'banks/' . $image['logo']; // Fixed 'logo' field
                    if (file_exists($old_img)) {
                        @unlink($old_img); // Delete the file silently
                    }
                }
            }
    
            // Check if all the bank IDs exist
            $sqlCheck = "SELECT `id` FROM `banks` WHERE `id` IN ($placeholders)";
            $stmtCheck = $pdo->prepare($sqlCheck);
    
            foreach ($ids as $index => $id) {
                $stmtCheck->bindValue($index + 1, $id, PDO::PARAM_INT);
            }
    
            $stmtCheck->execute();
            $existingIds = $stmtCheck->fetchAll(PDO::FETCH_COLUMN);
    
            // Check for non-existing IDs
            $nonExistingIds = array_diff($ids, $existingIds);
            if (!empty($nonExistingIds)) {
                $nonExistingIdsString = implode(', ', $nonExistingIds);
                return [
                    "status" => 404,
                    "message" => "The following IDs do not exist in the database: $nonExistingIdsString"
                ];
            }
    
            // Perform the deletion
            $sqlDelete = "DELETE FROM `banks` WHERE `id` IN ($placeholders)";
            $stmtDelete = $pdo->prepare($sqlDelete);
    
            foreach ($ids as $index => $id) {
                $stmtDelete->bindValue($index + 1, $id, PDO::PARAM_INT);
            }
    
            if ($stmtDelete->execute()) {
                $pdo->commit();
                return [
                    "status" => 200,
                    "message" => "Bank(s) deleted successfully."
                ];
            } else {
                $pdo->rollBack();
                return [
                    "status" => 500,
                    "message" => "Failed to delete bank(s)."
                ];
            }
        } catch (PDOException $e) {
            $pdo->rollBack();
            error_log("PDOException: " . $e->getMessage());
    
            return [
                "status" => 500,
                "message" => "Error occurred while deleting bank(s): " . $e->getMessage()
            ];
        }
    }
    
    function getOneBank($id) {
        try {
            $this->mDb->beginTransaction();
    
            $sql = "SELECT b.`id`, b.`added_by`, b.`status`,b.sort, b.`date_added`, b.`logo` 
                    FROM `banks` b WHERE b.`id` = :id";
    
            $stmt = $this->mDb->connect()->prepare($sql);
            $stmt->bindParam(':id', $id, PDO::PARAM_INT);
    
            if ($stmt->execute()) {
                $result = $stmt->fetch(PDO::FETCH_ASSOC);
                if (!$result) {
                    throw new Exception("bank with ID $id not found.");
                }
            } else {
                throw new Exception("Error executing the main SQL statement: " . implode(", ", $stmt->errorInfo()));
            }
    
            $sqlLangs = "SELECT bl.`lang_code`, bl.`name`
                        FROM `banks_langs` bl WHERE bl.`bank_id` = :id";
            $stmtLangs = $this->mDb->connect()->prepare($sqlLangs);
            $stmtLangs->bindParam(':id', $id, PDO::PARAM_INT);
    
            if ($stmtLangs->execute()) {
                $result['langs'] = $stmtLangs->fetchAll(PDO::FETCH_ASSOC);
            } else {
                throw new Exception("Error executing the languages SQL statement: " . implode(", ", $stmtLangs->errorInfo()));
            }
    
            // Commit the transaction after both queries are successful
            $this->mDb->commit();
    
            return $result;
        } catch (Exception $e) {
            // Rollback in case of any error
            $this->mDb->rollBack();
            return ["status" => 500, "message" => "An error occurred: " . $e->getMessage()];
        }
    }

public function countBanksByFilters($searchName = '', $sort = '', $lang_code = 'ar') {
    $lang_code = $lang_code ?: 'ar'; 

    $hasFilters = false;

    if (trim($searchName) !== '') {
        $hasFilters = true;
    }

    if (trim($sort) !== '') {
        $hasFilters = true;
    }

    $sql = "SELECT COUNT(DISTINCT b.id)
            FROM banks b
            LEFT JOIN banks_langs bl ON b.id = bl.bank_id AND bl.lang_code = ?
            WHERE b.is_deleted = 0";

    $params = [$lang_code];

    if (trim($searchName) !== '') {
        $sql .= " AND bl.name LIKE ?";
        $params[] = '%' . $searchName . '%';
    }

    if (trim($sort) !== '') {
        $sql .= " AND b.sort = ?";
        $params[] = $sort;
    }

    try {
        $stmt = $this->mDb->connect()->prepare($sql);
        $stmt->execute($params);
        $count = $stmt->fetchColumn();

        return [
            'status' => 200,
            'count' => intval($count),
            'filtered' => $hasFilters
        ];
    } catch (PDOException $e) {
        return [
            'status' => 500,
            'message' => 'Database Error: ' . $e->getMessage()
        ];
    }
}

}