<?php

$atmsObj = new atms();

class atms
{

	var $mDb;
	var $mConfig;
	var $mlang;
    

	function __construct()
	{
		global $Config;
		global $Lang;
		$this->mDb = new iplus();
		$this->mConfig = $Config;
		$this->mlang = $Lang;
     
	}

	function convert_object_to_array($data)
	{

		if (is_object($data)) {
			$data = get_object_vars($data);
		}

		if (is_array($data)) {
			return array_map(__METHOD__, $data);
		} else {
			return $data;
		}
	}

	function getAllAtms($aStart, $aLimit, $type,$sort,  $searchaddress, $searchBankId) {
        $lang_code = LANGUAGE;
        
        // Validate if the searchBankId exists in the branches table
        if ($searchBankId) {
            $validationSql = "SELECT COUNT(*) AS count FROM atms WHERE bank_id = :searchBankId AND is_deleted = 0";
        // ده سطر الكويري بيعمل  سيلكت عشان يجب عدد المكن اللي مسجل برقم البنك ويسجلهم في عمود اسمه كونيت
            try {
                
                $validationStmt = $this->mDb->connect()->prepare($validationSql);
                //iplus هنا بيعمل تحضير لسطر السيلكت اللي فوق وبيتصل بالداتا بيز بدالة موجودة في ملف 
                $validationStmt->bindParam(':searchBankId', $searchBankId, PDO::PARAM_INT);
                // في سطر الكويري بعد دخوله من البوست مان عن طريق التيست  searchBankId  هنا عشان يقدر يدخل 
                $validationStmt->execute();
                $validationResult = $validationStmt->fetch(PDO::FETCH_ASSOC);
    
                if ($validationResult['count'] == 0) {
                    return ['error' => "Bank ID {$searchBankId} does not exist in the atms table."];
                }
            } catch (PDOException $e) {
                error_log("PDOException in validating searchBankId: " . $e->getMessage());
                return ['error' => "An error occurred while validating the Bank ID."];
            }
        }
    
        // Main query
        $sql = "SELECT a.*, al.address
                FROM atms a
                LEFT JOIN atms_langs al ON a.id = al.atm_id AND al.lang_code = :lang_code
                WHERE a.is_deleted = 0 ";
    
        if ($searchaddress) {
            $sql .= " AND al.address LIKE :searchaddress";
        }
        if ($searchBankId) {
            $sql .= " AND a.bank_id = :searchBankId";
        }
        if ($sort == 'address') {
            $sql .= " ORDER BY al.address {$type}";
        } else {
            $sql .= " ORDER BY a.{$sort} {$type}";
        }
        if ($aLimit) {
            $sql .= " LIMIT :aStart, :aLimit";
        }
        // echo ($sql);die();
        try {
            $this->mDb->connect()->beginTransaction();
    
            $stmt = $this->mDb->connect()->prepare($sql);
            $stmt->bindParam(':lang_code', $lang_code, PDO::PARAM_STR);
    
            if ($searchaddress) {
                $stmt->bindParam(':searchaddress', $searchaddress, PDO::PARAM_STR);
            }
            if ($searchBankId) {
                $stmt->bindParam(':searchBankId', $searchBankId, PDO::PARAM_INT);
            }
    
            if ($aLimit) {
                $stmt->bindParam(':aStart', $aStart, PDO::PARAM_INT);
                $stmt->bindParam(':aLimit', $aLimit, PDO::PARAM_INT);
            }
    
            $stmt->execute();
            $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
            $this->mDb->connect()->commit();
            return $results;
    
        } catch (PDOException $e) {
            $this->mDb->connect()->rollBack();
            error_log("PDOException in getAllPages: " . $e->getMessage());
            return array();
        }
    }
    function getSearchAtmsCount($searchaddress, $searchBankId) {
		$lang_code = LANGUAGE;
        $sql = "SELECT COUNT(a.`id`) as count 
                FROM atms a
                LEFT JOIN atms_langs al ON a.id = al.atm_id AND al.lang_code = :lang_code
                WHERE a.is_deleted = 0 ";
    
        if (!empty($searchaddress)) {
            $sql .= " AND al.address LIKE :searchaddress";
        }
        if (!empty($searchBankId)) {
            $sql .= " AND al.bank_id LIKE :searchBankId";
        }
		// echo ($sql);die();
        try {
            $this->mDb->connect()->beginTransaction();
    
            $stmt = $this->mDb->connect()->prepare($sql);
            $stmt->bindParam(':lang_code', $lang_code, PDO::PARAM_STR);
    
            if (!empty($searchaddress)) {
                $stmt->bindParam(':searchaddress', $searchaddress, PDO::PARAM_STR);
            }
            if (!empty($searchBankId)) {
                $stmt->bindParam(':searchBankId', $searchBankId, PDO::PARAM_INT);
            }
    
            $stmt->execute();
            $resultCount = $stmt->fetchColumn();
    
            $this->mDb->connect()->commit();
            return $resultCount;
    
        } catch (PDOException $e) {
            $this->mDb->connect()->rollBack();
            error_log("PDOException in getSearchBanksCount: " . $e->getMessage());
            return 0;
        }
    }

	function getOneAtm($id) {
        try {
            $this->mDb->beginTransaction();
    
            $sql = "SELECT a.*
                    FROM `atms` a WHERE a.`id` = :id";
    
            $stmt = $this->mDb->connect()->prepare($sql);
            $stmt->bindParam(':id', $id, PDO::PARAM_INT);
    
            if ($stmt->execute()) {
                $result = $stmt->fetch(PDO::FETCH_ASSOC);
                if (!$result) {
                    throw new Exception("ATM with ID $id not found.");
                }
            } else {
                throw new Exception("Error executing the main SQL statement: " . implode(", ", $stmt->errorInfo()));
            }
    
            $sqlLangs = "SELECT al.`lang_code`, al.`address`
                         FROM `atms_langs` al WHERE al.`atm_id` = :id";
            $stmtLangs = $this->mDb->connect()->prepare($sqlLangs);
            $stmtLangs->bindParam(':id', $id, PDO::PARAM_INT);
    
            if ($stmtLangs->execute()) {
                $result['langs'] = $stmtLangs->fetchAll(PDO::FETCH_ASSOC);
            } else {
                throw new Exception("Error executing the languages SQL statement: " . implode(", ", $stmtLangs->errorInfo()));
            }
    
            // Commit the transaction after both queries are successful
            $this->mDb->commit();
    
            return $result;
        } catch (Exception $e) {
            // Rollback in case of any error
            $this->mDb->rollBack();
            return ["status" => 500, "message" => "An error occurred: " . $e->getMessage()];
        }
    }
	function getBankAtms($bankId) {
        try {
            $this->mDb->beginTransaction();
    
            $sql = "SELECT a.*
                    FROM atms a 
                    WHERE a.bank_id = :bank_id AND a.is_deleted = 0";
    
            $stmt = $this->mDb->connect()->prepare($sql);
            $stmt->bindParam(':bank_id', $bankId, PDO::PARAM_INT);
    
            if ($stmt->execute()) {
                $atms = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
                if (!$atms) {
                    throw new Exception("No ATMS found for bank ID $bankId.");
                }
            } else {
                throw new Exception("Error executing ATMS SQL: " . implode(", ", $stmt->errorInfo()));
            }
    
            $result = ['ATMS' => []];
    
            foreach ($atms as $atm) {
                $atmId = $atm['id'];
    
                $sqlLangs = "SELECT al.lang_code, al.address
                             FROM atms_langs al 
                             WHERE al.atm_id = :atm_id";
    
                $stmtLangs = $this->mDb->connect()->prepare($sqlLangs);
                $stmtLangs->bindParam(':atm_id', $atmId, PDO::PARAM_INT);
    
                if ($stmtLangs->execute()) {
                    $atmLangs = $stmtLangs->fetchAll(PDO::FETCH_ASSOC);
    
                    // Add branch data along with its language details directly
                    $atm['langs'] = $atmLangs;
                    $result['atms'][] = $atm;
                } else {
                    throw new Exception("Error executing atms_langs SQL for atm ID $atmId: " . implode(", ", $stmtLangs->errorInfo()));
                }
            }
    
            // Commit the transaction
            $this->mDb->commit();
    
            return $result ;
    
        } catch (Exception $e) {
            // Rollback in case of any error
            $this->mDb->rollBack();
            return ["status" => 500, "message" => "An error occurred: " . $e->getMessage()];
        }
    }
	function addEditBankAtm($request) {
        // Validate 'added_by' field
        if (isset($request['added_by']) && !is_int($request['added_by']) && !ctype_digit($request['added_by'])) {
            return ["status" => 400, "message" => "'added_by' must be an integer"];
        }
    
        unset($request['action']);
        $dataLangObj = json_decode($request['langs']);
        $newDataLangObj = $this->convert_object_to_array($dataLangObj);
        $dateTime = date('Y-m-d H:i:s');
    
        // Check if bank exists
        $sqlCheckBank = "SELECT COUNT(*) FROM banks WHERE id = :bank_id";
        $stmtCheckBank = $this->mDb->connect()->prepare($sqlCheckBank);
        $stmtCheckBank->bindParam(':bank_id', $request['bank_id'], PDO::PARAM_INT);
        $stmtCheckBank->execute();
        $bankExists = $stmtCheckBank->fetchColumn();
    
        if (!$bankExists) {
            return ["status" => 404, "message" => "The bank does not exist"];
        }
    
        if (!($request['id'])) {
            // Insert operation
            $sql = "INSERT INTO atms SET added_by = :added_by, date_added = :dateTime";
            $sql .= ", bank_id = :bank_id";
			$sql .= ", code = :code";
            $sql .= ", latitude = :latitude";
            $sql .= ", longitude = :longitude";
            $sql .= ", status = :status";
            $sql .= ", sort = :sort";
    
            try {
                $this->mDb->beginTransaction();
                $stmt = $this->mDb->connect()->prepare($sql);
    
                $stmt->bindParam(':added_by', $request['added_by'], PDO::PARAM_INT);
                $stmt->bindParam(':dateTime', $dateTime);
                $stmt->bindParam(':bank_id', $request['bank_id'], PDO::PARAM_INT);
                $stmt->bindParam(':latitude', $request['latitude']);
                $stmt->bindParam(':longitude', $request['longitude']);
				$stmt->bindParam(':code', $request['code'], PDO::PARAM_INT);
                $stmt->bindParam(':status', $request['status'], PDO::PARAM_INT);
                $stmt->bindParam(':sort', $request['sort'], PDO::PARAM_INT);
    
                $stmt->execute();
    
                $last_id = $this->mDb->getLastInsertId();
                foreach ($newDataLangObj as $key => $value) {
                    $sqlForLang = "INSERT INTO atms_langs (atm_id, lang_code, address) VALUES (:atm_id, :lang_code, :address)";
                    $stmtForLang = $this->mDb->connect()->prepare($sqlForLang);
                    $stmtForLang->bindParam(':atm_id', $last_id, PDO::PARAM_INT);
                    $stmtForLang->bindParam(':lang_code', $value['lang_code']);
                    $stmtForLang->bindParam(':address', $value['address'], PDO::PARAM_STR);
                    
                    $stmtForLang->execute();
                }
    
                $this->mDb->commit();
                return ["status" => 200, "message" => "ATM added successfully"];
            } catch (PDOException $e) {
                $this->mDb->rollBack();
                return ["status" => 500, "message" => "An error occurred"];
            }
        } else {
            // Update operation
            $sql = "UPDATE atms SET date_added = :date_added, bank_id = :bank_id, latitude = :latitude, 
                    longitude = :longitude, code = :code, status = :status, sort = :sort 
                    WHERE id = :id";
    
            try {
                $this->mDb->beginTransaction();
                $stmt = $this->mDb->connect()->prepare($sql);
    
                $stmt->bindParam(':date_added', $request['date_added']);
                $stmt->bindParam(':bank_id', $request['bank_id'], PDO::PARAM_INT);
                $stmt->bindParam(':latitude', $request['latitude']);
                $stmt->bindParam(':longitude', $request['longitude']);
				$stmt->bindParam(':code', $request['code'], PDO::PARAM_INT);
                $stmt->bindParam(':status', $request['status'], PDO::PARAM_INT);
                $stmt->bindParam(':sort', $request['sort'], PDO::PARAM_INT);
                $stmt->bindParam(':id', $request['id'], PDO::PARAM_INT);
    
                $stmt->execute();
    
                // Update languages for the branch
                foreach ($newDataLangObj as $key => $value) {
                    $sqlForLang = "UPDATE atms_langs SET address = :address WHERE atm_id = :atm_id AND lang_code = :lang_code";
                    $stmtForLang = $this->mDb->connect()->prepare($sqlForLang);
                    $stmtForLang->bindParam(':address', $value['address']);
                    $stmtForLang->bindParam(':atm_id', $request['id'], PDO::PARAM_INT);
                    $stmtForLang->bindParam(':lang_code', $value['lang_code']);
                    $stmtForLang->execute();
                }
    
                $this->mDb->commit();
                return ["status" => 200, "message" => "Branch updated successfully"];
            } catch (PDOException $e) {
                $this->mDb->rollBack();
                return ["status" => 500, "message" => "An error occurred"];
            }
        }
    }
    public function deleteAtm($ids)
{
    if (empty($ids) || !is_array($ids)) {
        return [
            "status" => 400,
            "message" => "Invalid input. Please provide an array of ATM IDs."
        ];
    }

    try {
        $pdo = $this->mDb->connect();
        $pdo->beginTransaction();

        // حذف الترجمات
// atms_langsمسح سوفت كان بيمسح كمان لغاته من  atm  انا عملت هاش للتلت سطور بسبب اني كل ما كنت امسح داتا من 
        $placeholders = implode(',', array_fill(0, count($ids), '?'));
        // $sqlDeleteLangs = "DELETE FROM `atms_langs` WHERE `atm_id` IN ($placeholders)";
        // $stmtDeleteLangs = $pdo->prepare($sqlDeleteLangs);
        // $stmtDeleteLangs->execute($ids);

        // تحقق من الـ IDs
        $sqlCheck = "SELECT `id` FROM `atms` WHERE `id` IN ($placeholders)";
        $stmtCheck = $pdo->prepare($sqlCheck);
        $stmtCheck->execute($ids);
        $existingIds = $stmtCheck->fetchAll(PDO::FETCH_COLUMN);

        $nonExistingIds = array_diff($ids, $existingIds);
        if (!empty($nonExistingIds)) {
            return [
                "status" => 404,
                "message" => "The following ATM IDs do not exist: " . implode(', ', $nonExistingIds)
            ];
        }

        $binds = [];
        $where = [];
        foreach ($ids as $i => $id) {
            $key = ":id$i";
            $where[] = "id = $key";
            $binds[$key] = $id;
        }

        $sqlUpdate = "UPDATE `atms` SET `is_deleted` = 1 WHERE " . implode(' OR ', $where);
        $stmtUpdate = $pdo->prepare($sqlUpdate);

        foreach ($binds as $key => $value) {
            $stmtUpdate->bindValue($key, $value, PDO::PARAM_INT);
        }

        $stmtUpdate->execute();

        error_log("Affected rows: " . $stmtUpdate->rowCount());

        $pdo->commit();
        return [
            "status" => 200,
            "message" => "ATM(s) soft deleted successfully."
        ];
    } catch (PDOException $e) {
        $pdo->rollBack();
        error_log("PDOException in deleteAtm: " . $e->getMessage());

        return [
            "status" => 500,
            "message" => "Error deleting ATM(s): " . $e->getMessage()
        ];
    }
}
public function restoreAtm($ids)
{
    if (empty($ids) || !is_array($ids)) {
        return [
            "status" => 400,
            "message" => "Invalid input. Please provide an array of ATM IDs."
        ];
    }

    try {
        $pdo = $this->mDb->connect();
        $pdo->beginTransaction();

        // التحقق من أن الـ IDs موجودة
        $placeholders = implode(',', array_fill(0, count($ids), '?'));
        $sqlCheck = "SELECT `id` FROM `atms` WHERE `id` IN ($placeholders)";
        $stmtCheck = $pdo->prepare($sqlCheck);
        $stmtCheck->execute($ids);
        $existingIds = $stmtCheck->fetchAll(PDO::FETCH_COLUMN);

        $nonExistingIds = array_diff($ids, $existingIds);
        if (!empty($nonExistingIds)) {
            return [
                "status" => 404,
                "message" => "The following ATM IDs do not exist: " . implode(', ', $nonExistingIds)
            ];
        }

        // استرجاع البيانات: is_deleted = 0
        $binds = [];
        $where = [];
        foreach ($ids as $i => $id) {
            $key = ":id$i";
            $where[] = "id = $key";
            $binds[$key] = $id;
        }

        $sqlUpdate = "UPDATE `atms` SET `is_deleted` = 0 WHERE " . implode(' OR ', $where);
        $stmtUpdate = $pdo->prepare($sqlUpdate);

        foreach ($binds as $key => $value) {
            $stmtUpdate->bindValue($key, $value, PDO::PARAM_INT);
        }

        $stmtUpdate->execute();

        $pdo->commit();
        return [
            "status" => 200,
            "message" => "ATM(s) restored successfully."
        ];
    } catch (PDOException $e) {
        $pdo->rollBack();
        error_log("PDOException in restoreAtm: " . $e->getMessage());

        return [
            "status" => 500,
            "message" => "Error restoring ATM(s): " . $e->getMessage()
        ];
    }
}



public function countAtmsByFilters($sort = '', $searchaddress = '', $searchBankId = null)
{
    $sql = "SELECT COUNT(DISTINCT a.id)
            FROM atms a
            LEFT JOIN banks b ON b.id = a.bank_id
            left join atms_langs al on a.id = al.atm_id
            WHERE 1";
    
    $params = [];
    $hasFilters = false;

    if (!empty($sort)) {
        $sql .= " AND a.sort = ?";
        $params[] = $sort;
        $hasFilters = true;
    }

    if (!empty($searchaddress)) {
        $sql .= " AND al.address LIKE ?";
        $params[] = '%' . $searchaddress . '%';
        $hasFilters = true;
    }

    if (is_numeric($searchBankId) && intval($searchBankId) > 0) {
        $sql .= " AND a.bank_id = ?";
        $params[] = intval($searchBankId);
        $hasFilters = true;
    }

    try {
        $stmt = $this->mDb->connect()->prepare($sql);
        $stmt->execute($params);
        $count = $stmt->fetchColumn();

        return [
            'status' => 200,
            'count' => intval($count),
            'filtered' => $hasFilters
        ];
    } catch (PDOException $e) {
        return [
            'status' => 500,
            'message' => 'Database Error: ' . $e->getMessage()
        ];
    }
}





}