<?php
$atmMaintenanceObj = new  atm_maintenance();
class atm_maintenance
{
    var $mDb;
    var $mConfig;
    var $mlang;

    function __construct()
    {
        global $Config;
        global $Lang;
        $this->mDb = new iplus();
        $this->mConfig = $Config;
        $this->mlang = $Lang;
    }

    function convert_object_to_array($data)
    {
        if (is_object($data)) {
            $data = get_object_vars($data);
        }

        if (is_array($data)) {
            return array_map(__METHOD__, $data);
        } else {
            return $data;
        }
    }

    function getAllLogs($atm_id, $searchAtmId)
    {
        $lang_code = LANGUAGE;

        // التحقق من أن ATM موجود لو تم إدخال searchAtmId
        if ($searchAtmId) {
            $validationSql = "SELECT COUNT(*) AS count FROM atms WHERE id = :searchAtmId AND is_deleted = 0";
            try {
                $validationStmt = $this->mDb->connect()->prepare($validationSql);
                $validationStmt->bindParam(':searchAtmId', $searchAtmId, PDO::PARAM_INT);
                $validationStmt->execute();
                $validationResult = $validationStmt->fetch(PDO::FETCH_ASSOC);

                if ($validationResult['count'] == 0) {
                    return ['status' => 404, 'message' => "ATM ID {$searchAtmId} does not exist."];
                }
            } catch (PDOException $e) {
                return ['status' => 500, 'message' => "Validation error: " . $e->getMessage()];
            }
        }


        // $sql = "SELECT * FROM atm_maintenance_logs WHERE 1=1";
        $sql = "SELECT logs.*, atms.bank_id, bl.name AS bank_name
        FROM atm_maintenance_logs logs
        LEFT JOIN atms ON logs.atm_id = atms.id
        LEFT JOIN banks_langs bl ON atms.bank_id = bl.bank_id AND bl.lang_code = :lang_code
        WHERE 1=1";

        if (!empty($atm_id)) {
            $sql .= " AND logs.atm_id = :atm_id";
        }

        try {
            $this->mDb->connect()->beginTransaction();
            $stmt = $this->mDb->connect()->prepare($sql);

            $stmt->bindParam(':lang_code', $lang_code, PDO::PARAM_STR);

            if (!empty($atm_id)) {
                $stmt->bindParam(':atm_id', $atm_id, PDO::PARAM_INT);
            }

            $stmt->execute();
            $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
            $this->mDb->connect()->commit();

            return $results;
        } catch (PDOException $e) {
            $this->mDb->connect()->rollBack();
            return ['status' => 500, 'message' => "Error fetching logs: " . $e->getMessage()];
        }
    }

    function addEditMaintenanceLog($request)
    {
        // تحقق من الرقم
        if (isset($request['atm_id']) && !is_numeric($request['atm_id'])) {
            return ["status" => 400, "message" => "'atm_id' must be an integer"];
        }

        unset($request['action']);
        $dateTime = date('Y-m-d H:i:s');

        // تأكد من وجود ماكينة الصراف
        $sqlCheckAtm = "SELECT COUNT(*) FROM atms WHERE id = :atm_id AND is_deleted = 0";
        $stmtCheck = $this->mDb->connect()->prepare($sqlCheckAtm);
        $stmtCheck->bindParam(':atm_id', $request['atm_id'], PDO::PARAM_INT);
        $stmtCheck->execute();
        $atmExists = $stmtCheck->fetchColumn();

        if (!$atmExists) {
            return ["status" => 404, "message" => "The ATM does not exist"];
        }

        if (empty($request['id'])) {
            // عملية الإضافة
            $sql = "INSERT INTO atm_maintenance_logs (atm_id, maintenance_date, issue_description, fixed_by, status, created_at)
                VALUES (:atm_id, :maintenance_date, :issue_description, :fixed_by, :status, :created_at)";

            try {
                $this->mDb->beginTransaction();
                $stmt = $this->mDb->connect()->prepare($sql);

                $stmt->bindParam(':atm_id', $request['atm_id'], PDO::PARAM_INT);
                $stmt->bindParam(':maintenance_date', $request['maintenance_date']);
                $stmt->bindParam(':issue_description', $request['issue_description']);
                $stmt->bindParam(':fixed_by', $request['fixed_by']);
                $stmt->bindParam(':status', $request['status']);
                $stmt->bindParam(':created_at', $dateTime);

                $stmt->execute();
                $this->mDb->commit();
                return ["status" => 200, "message" => "Maintenance log added successfully"];
            } catch (PDOException $e) {
                $this->mDb->rollBack();
                return ["status" => 500, "message" => $e->getMessage()];
            }
        } else {
            // عملية التعديل
            $sql = "UPDATE atm_maintenance_logs SET 
                    atm_id = :atm_id, 
                    maintenance_date = :maintenance_date, 
                    issue_description = :issue_description, 
                    fixed_by = :fixed_by, 
                    status = :status
                WHERE id = :id";

            try {
                $this->mDb->beginTransaction();
                $stmt = $this->mDb->connect()->prepare($sql);

                $stmt->bindParam(':id', $request['id'], PDO::PARAM_INT);
                $stmt->bindParam(':atm_id', $request['atm_id'], PDO::PARAM_INT);
                $stmt->bindParam(':maintenance_date', $request['maintenance_date']);
                $stmt->bindParam(':issue_description', $request['issue_description']);
                $stmt->bindParam(':fixed_by', $request['fixed_by']);
                $stmt->bindParam(':status', $request['status']);


                $stmt->execute();
                $affectedRows = $stmt->rowCount();
                $this->mDb->commit();

                if ($affectedRows === 0) {
                    return ["status" => 404, "message" => "No maintenance log found with the given ID."];
                }

                return ["status" => 200, "message" => "Maintenance log updated successfully."];
            } catch (PDOException $e) {
                $this->mDb->rollBack();
                return ["status" => 500, "message" => $e->getMessage()];
            }
        }
    }

    public function deleteLogs($ids)
    {
        $deletedLogs = 0;
        $this->mDb->connect()->beginTransaction();

        try {
            $sqlDelete = "DELETE FROM `atm_maintenance_logs` WHERE `id` = :id";

            foreach ($ids as $id) {
                // تحقق من وجود السجل أولاً
                $query = "SELECT `id` FROM `atm_maintenance_logs` WHERE `id` = :id";
                $stmt = $this->mDb->connect()->prepare($query);
                $stmt->bindParam(':id', $id, PDO::PARAM_INT);
                $stmt->execute();

                $result = $stmt->fetch(PDO::FETCH_ASSOC);

                if ($result) {
                    $stmtDelete = $this->mDb->connect()->prepare($sqlDelete);
                    $stmtDelete->bindParam(':id', $id, PDO::PARAM_INT);
                    $stmtDelete->execute();

                    if ($stmtDelete->rowCount() > 0) {
                        $deletedLogs++;
                    }
                }
            }

            if ($deletedLogs === 0) {
                $this->mDb->connect()->rollBack();

                return [
                    "status" => 404,
                    "message" => "No maintenance log(s) deleted"
                ];
            }

            $this->mDb->connect()->commit();

            return [
                "status" => 200,
                "message" => "Maintenance log(s) deleted successfully"
            ];
        } catch (PDOException $e) {
            $this->mDb->connect()->rollBack();

            return [
                "status" => 500,
                "message" => "An error occurred while deleting: " . $e->getMessage()
            ];
        }
    }

    function getOneLog($id)
    {
        try {
            $this->mDb->beginTransaction();

            $sql = "SELECT l.*
                FROM `atm_maintenance_logs` l
                WHERE l.`id` = :id";

            $stmt = $this->mDb->connect()->prepare($sql);
            $stmt->bindParam(':id', $id, PDO::PARAM_INT);

            if ($stmt->execute()) {
                $result = $stmt->fetch(PDO::FETCH_ASSOC);
                if (!$result) {
                    throw new Exception("Maintenance log with ID $id not found.");
                }
            } else {
                throw new Exception("Error executing the main SQL statement: " . implode(", ", $stmt->errorInfo()));
            }

            $this->mDb->commit();
            return $result;
        } catch (Exception $e) {
            $this->mDb->rollBack();
            return [
                "status" => 500,
                "message" => "An error occurred: " . $e->getMessage()
            ];
        }
    }


    public function countAtmLogsByFilters($log_id = null, $searchAtmId = null){
        $sql = "SELECT COUNT(DISTINCT l.id)
        FROM atm_maintenance_logs l
        left join atms a on l.atm_id = a.id 
        WHERE 1";

        $params = [];
        $hasFilters = false;

        if (is_numeric($log_id) && intval($log_id) > 0) {
            $sql .= " AND l.id = ?";
            $params[] = intval($log_id);
            $hasFilters = true;
        }

        if (is_numeric($searchAtmId) && intval($searchAtmId) > 0) {
            $sql .= " AND l.atm_id = ?";
            $params[] = intval($searchAtmId);
            $hasFilters = true;
        }

        try {
            $stmt = $this->mDb->connect()->prepare($sql);
            $stmt->execute($params);
            $count = $stmt->fetchColumn();

            return [
                'status' => 200,
                'count' => intval($count),
                'filtered' => $hasFilters
            ];
        } catch (PDOException $e) {
            return [
                'status' => 500,
                'message' => 'Database Error: ' . $e->getMessage()
            ];
        }
    }
}
