<?php

/*************************************************************************
 *
 *   PROJECT: Tahalya app - Categories API
 *   powered by IT PLUS Team
 *   Copyright 2020 IT Plus Inc
 *   http://it-plus.co/
 * *************************************************************************/

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET,POST,PUT,DELETE,OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

require_once 'init.php';

$postdata = file_get_contents("php://input");
$Req = json_decode($postdata, TRUE);

if ($_GET['action'] == 'getMainCategories') {
    if (!isset($_GET['searchParentId']) || $_GET['searchParentId'] === ''||$_GET['searchParentId']<0) {
        $Data['status'] = 400;
        $Data['success'] = false;
        $Data['message'] = "you should enter parent id for searching ";
        echo json_encode($Data);
        exit;
    }


    // قراءة الباراميترز من الطلب
    $lang_code        = isset($_GET['lang_code']) ? $_GET['lang_code'] : 'ar';
    $searchName       = isset($_GET['searchName']) ? $_GET['searchName'] : '';
    $searchId         = isset($_GET['searchId']) ? $_GET['searchId'] : '';
    // $searchParentId   = (isset($_GET['searchParentId']) && $_GET['searchParentId'] !== '') ? $_GET['searchParentId'] : null;
    $searchParentId   = (int)$_GET['searchParentId'];
    $searchSort       = isset($_GET['searchSort']) ? $_GET['searchSort'] : '';
    $aStart           = isset($_GET['start']) ? (int)$_GET['start'] : 0;
    $aLimit           = isset($_GET['limit']) ? (int)$_GET['limit'] : 10;
    $type             = isset($_GET['order']) ? $_GET['order'] : 'ASC';

    // استدعاء الدالة
    $catsData = $categoriesObj->getMainCategories(
        $searchName,
        $searchId,
        $searchParentId,
        $searchSort,
        $lang_code,
        $aStart,
        $aLimit,
        $type
    );

    $catsCount = is_array($catsData) ? count($catsData) : 0;

    if (!empty($catsData)) {
        $Data['status'] = 200;
        $Data['success'] = true;
        $Data['count'] = $catsCount;
        $Data['data'] = $catsData;
    } else {
        $Data['status'] = 204;
        $Data['success'] = false;
        $Data['message'] = "No categories found";
        $Data['data'] = [];
        $Data['count'] = 0;
    }

}

if ($_GET['action'] == 'getAllWithLang') {

    $lang_code = isset($_GET['lang_code']) ? $_GET['lang_code'] : 'ar';

    $categories = $categoriesObj->getAllCategoriesWithLang($lang_code);
    $categoriesCount = is_array($categories) ? count($categories) : 0;

    if (!empty($categories)) {
        $Data['data'] = $categories;
        $Data['count'] = $categoriesCount;
        $Data['success'] = true;
    } else {
        $Data['data'] = [];
        $Data['count'] = 0;
        $Data['success'] = false;
    }
}

if ($_GET['action'] == 'getOneCategory') {
    $id = isset($_GET['id']) ? intval($_GET['id']) : 0;
    $lang_code = isset($_GET['lang_code']) ? $_GET['lang_code'] : 'ar';

    $result = $categoriesObj->getOneCategory($id, $lang_code);

    $Data['data'] = $result['data'] ?? null;
    $Data['status'] = $result['status'];
    // $Data['message'] = $result['message'] ?? '';
    $Data['success'] = $result['status'] == 200;
}

if ($_GET['action'] == 'addEditCategory') {

    $addedData = $categoriesObj->addEditCategory($Req);
    if ($addedData && isset($addedData['status']) && $addedData['status'] == 200) {
        $Data['data'] = $addedData;
        $Data['success'] = true;
    } else {
        $Data['data'] = $addedData;
        $Data['msg'] = 'failed';
        $Data['success'] = false;
    }

    echo json_encode($Data, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    exit;
}

if ($_GET['action'] == 'getCategoryWithChildren') {
    $id = isset($_GET['id']) ? intval($_GET['id']) : 0;
    $lang_code = isset($_GET['lang_code']) ? $_GET['lang_code'] : 'ar';

    $result = $categoriesObj->getCategoryWithChildren($id, $lang_code);

    $Data['data'] = $result['data'] ?? null;
    $Data['status'] = $result['status'];
    $Data['message'] = $result['message'] ?? '';
    $Data['success'] = $result['status'] == 200;
}


// if ($_GET['action'] == 'getCategoryTree') {
//     $lang = isset($_GET['lang_code']) ? $_GET['lang_code'] : 'ar';

//     $tree = $categoriesObj->getCategoryTree($lang);

//     $Data['data'] = $tree;
//     $Data['success'] = true;
//     echo json_encode($Data, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
//     exit;
// }


if ($_GET['action'] == 'deleteCategory') {
    $id = isset($Req['id']) ? intval($Req['id']) : 0;
    $result = $categoriesObj->deleteCategoryWithChildren($id);

    $Data['status'] = $result['status'];
    $Data['message'] = $result['message'];
    $Data['deleted_ids'] = $result['deleted_ids'] ?? [];
    $Data['success'] = $result['status'] == 200;
}

if ($_GET['action'] == 'searchCategories') {
    $searchName = isset($_GET['searchName']) ? $_GET['searchName'] : '';
    $searchId = isset($_GET['searchId']) ? $_GET['searchId'] : '';
    $searchParentId = isset($_GET['searchParentId']) ? $_GET['searchParentId'] : '';
    $searchSort = isset($_GET['searchSort']) ? $_GET['searchSort'] : '';
    $lang_code = isset($_GET['lang_code']) ? $_GET['lang_code'] : 'ar';

    $categories = $categoriesObj->getSearchCategories($searchName, $searchId, $searchParentId, $searchSort, $lang_code);
    $count = $categoriesObj->getSearchCategoriesCount($searchName, $searchId, $searchParentId, $searchSort);

    $Data['data'] = $categories;
    $Data['count'] = $count;
    $Data['success'] = true;
}

if ($_GET['action'] == 'getCategoriesCount') {
    $searchName = isset($_GET['searchName']) ? trim($_GET['searchName']) : '';
    $searchId = isset($_GET['searchId']) ? intval($_GET['searchId']) : '';
    $searchParentId = isset($_GET['searchParentId']) ? $_GET['searchParentId'] : '';
    $searchSort = isset($_GET['searchSort']) ? trim($_GET['searchSort']) : '';
    $lang_code = isset($_GET['lang_code']) ? $_GET['lang_code'] : 'ar'; // اللغة الافتراضية

    $result = $categoriesObj->getCategoriesCount(
        $searchName,
        $searchId,
        $searchParentId,
        $searchSort,
        $lang_code
    );

    echo json_encode($result, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    exit;
}

header('Content-Type: application/json');
echo json_encode($Data);
