<?php

/* * *************************************************************************
 *
 *   PROJECT: Tahalya app
 *   powerd by IT PLUS Team
 *   Copyright 2020 IT Plus Inc
 *   http://it-plus.co/ *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  */

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET,POST,PUT,DELETE,OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

require_once 'init.php';

$postdata = file_get_contents("php://input");


$Req = json_decode($postdata, TRUE);

if ($_GET['action'] == 'getAllBanks') {

  $searchName = $_GET['searchName'] ? $_GET['searchName'] : '';
  $aItemsPerPage = $_GET['aItemsPerPage'] ? $_GET['aItemsPerPage'] : 100;
  $start = $_GET['start'] ? $_GET['start'] : 0;
  $sort = $_GET['sort'] ? $_GET['sort'] : 'id';
  $type = $_GET['type'] ? $_GET['type'] : 'DESC';
  $lang_code = isset($_GET['lang_code']) ? trim($_GET['lang_code']) : 'ar';



  $bankData = $banksObj->getAllBanks($start, $aItemsPerPage, $sort, $type, $searchName);
  $bankCount = $banksObj->getSearchBanksCount($searchName, $lang_code);
  if ($bankData) {
    $Data['data'] = $bankData;
    $Data['count'] = $bankCount;
    $Data['success'] = true;
  } else {
    $Data['data'] = [];
    $Data['count'] = 0;
    $Data['success'] = false;
  }
}
if ($_GET['action'] == 'addEditBank') {
  $temp = array();

  $allow_ext = array("jpg", "gif", "png", "jpeg", "bmp", "webp");
  $maxsize = 1024 * 20;

  $uploadFolder = $Config['uploads_path'] . 'banks';
  // $uploadFolder = 'http://localhost/bankTime/'.$Config['uploads_path']. 'pages';
  $thumbsConfig = array(
    array(
      'name' => 'medium',
      'width' => '240',
      'hight' => '250'
    ),
    array(
      'name' => 'small',
      'width' => '80',
      'hight' => '80'
    ),
  );

  $upload = new Upload($allow_ext, $thumbsConfig, $maxsize, $uploadFolder, false);

  if (isset($_FILES['file']['name']) && $_FILES['file']['name'] != '') {
    $file['name'] = addslashes($_FILES["file"]["name"]);
    $file['type'] = $_FILES["file"]['type'];
    $file['size'] = $_FILES["file"]['size'] / 1024;
    $file['tmp'] = $_FILES["file"]['tmp_name'];
    $file['ext'] = $upload->GetExt($_FILES["file"]["name"]);

    if ($file['name'] != null) {
      // print_r($file['name']);die();
      $upfile = $upload->Upload_File($file, $maxsize);

      if ($upfile) {
        $temp['file'] = $upfile['newname'];
      } else {
        $error = true;
        $showError[] = $upload->showErrors();
        $top_msg['error'][] = $showError[0][0];
      }
    }
  } else {

    $temp['file'] = null;
  }
  $temp = array_merge($temp, $_REQUEST);
  $addedData = $banksObj->addEditBank($temp);
  if ($addedData) {
    $Data['data'] = $addedData;
    $Data['success'] = true;
  } else {
    $Data['data'] = null;
    $Data['msg'] = 'no_data';
    $Data['success'] = false;
  }
}

if ($_GET['action'] == 'getOneBank') {

  $oneBankData = $banksObj->getOneBank($_GET['id']);

  if ($oneBankData) {
    $Data['data'] = $oneBankData;
    $Data['success'] = true;
  } else {
    $Data['data'] = null;
    $Data['msg'] = 'no_data';
    $Data['success'] = false;
  }
}
if ($_GET['action'] == 'deleteBank' && $_SERVER['REQUEST_METHOD'] == 'POST') {

  if (isset($_POST['ids'])) {

    $ids = is_array($_POST['ids']) ? $_POST['ids'] : explode(',', $_POST['ids']);



    $deletedData = $banksObj->deleteBank($ids);

    if ($deletedData) {
      $Data['data'] = $deletedData;
      $Data['success'] = true;
    } else {
      $Data['data'] = null;
      $Data['msg'] = 'no_data';
      $Data['success'] = false;
    }
  } else {
    $Data['msg'] = 'No ID provided';
    $Data['success'] = false;
  }
}
if ($_GET['action'] == 'countBanks') {
  $searchName = isset($_GET['searchName']) ? trim($_GET['searchName']) : '';
  $sort = isset($_GET['sort']) ? trim($_GET['sort']) : '';
  $lang_code = isset($_GET['lang_code']) ? trim($_GET['lang_code']) : 'ar';

  $result = $banksObj->countBanksByFilters($searchName, $sort, $lang_code);

  echo json_encode($result, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
  exit;
}


echo json_encode($Data);
