<?php

/* * *************************************************************************
 *
 *   PROJECT: Tahalya app
 *   powerd by IT PLUS Team
 *   Copyright 2020 IT Plus Inc
 *   http://it-plus.co/ *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  */

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET,POST,PUT,DELETE,OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

require_once 'init.php';

$postdata = file_get_contents("php://input");
$Req = json_decode($postdata, TRUE);

if ($_GET['action'] == 'getAllAtms') {

    $start = $_GET['start'] ? $_GET['start'] : 0;
    $aItemsPerPage = $_GET['aItemsPerPage'] ? $_GET['aItemsPerPage'] : 100;

    $sort = $_GET['sort'] ? $_GET['sort'] : 'id';
    $type = $_GET['type'] ? $_GET['type'] : 'DESC';

    $searchaddress = $_GET['searchaddress'] ? $_GET['searchaddress'] : '';
    $searchBankId = $_GET['searchBankId'] ? $_GET['searchBankId'] : '';

    $atmsData = $atmsObj->getAllAtms($start, $aItemsPerPage, $sort, $type, $searchaddress, $searchBankId);
    $atmsCount = $atmsObj->getSearchAtmsCount($searchaddress,$searchBankId);
          if ($atmsData) {
            $Data['data'] = $atmsData;
            $Data['count'] = $atmsCount;
            $Data['success'] = true;
          } else {
            $Data['data'] = [];
           	$Data['count'] = 0;
            $Data['success'] = false;
          }
        


}
if ($_GET['action'] == 'addEditBankAtm') {
 
  $addedData = $atmsObj->addEditBankAtm($_REQUEST);
    if ($addedData) {
    $Data['data'] = $addedData;
    $Data['success'] = true;
  } else {
    $Data['data'] = null;
    $Data['msg'] = 'no_data';
    $Data['success'] = false;
  }
    
}

if ($_GET['action'] == 'getOneAtm') {

    $oneAtmData = $atmsObj->getOneAtm($_GET['id']);
    
    if ($oneAtmData) {
    $Data['data'] = $oneAtmData;
    $Data['success'] = true;
  } else {
    $Data['data'] = null;
    $Data['msg'] = 'no_data';
    $Data['success'] = false;
  }

}
if ($_GET['action'] == 'getBankAtms') {

    $bankAtmData = $atmsObj->getBankAtms($_GET['bank_id']);
    
    if ($bankAtmData) {
    $Data['data'] = $bankAtmData;
    $Data['success'] = true;
  } else {
    $Data['data'] = null;
    $Data['msg'] = 'no_data';
    $Data['success'] = false;
  }

}
// if ($_GET['action'] == 'deleteAtm' && $_SERVER['REQUEST_METHOD'] == 'POST') {

//     if (isset($_POST['ids'])) {
    
//         $ids = is_array($_POST['ids']) ? $_POST['ids'] : explode(',', $_POST['ids']);

   
   
//         $deletedData = $atmsObj->deleteAtm($ids);

//         if ($deletedData) {
//             $Data['data'] = $deletedData;
//             $Data['success'] = true;
//         } else {
//             $Data['data'] = null;
//             $Data['msg'] = 'no_data';
//             $Data['success'] = false;
//         }
//     } else {
//         $Data['msg'] = 'No ID provided';
//         $Data['success'] = false;
//     }


// }

if ($_GET['action'] == 'deleteAtm' && $_SERVER['REQUEST_METHOD'] == 'POST') {

    // قراءة البيانات من JSON body
    $rawInput = file_get_contents("php://input");
    $data = json_decode($rawInput, true); // true = decode as array

    // استخراج IDs من الـ JSON
    if (isset($data['ids'])) {

        if (is_array($data['ids'])) {
            $ids = $data['ids']; // ids: [1, 2, 3]
        } else {
            $ids = explode(',', $data['ids']); // ids: "1,2,3"
        }

        // تنظيف وتحويل القيم إلى أرقام صحيحة
        $ids = array_map('intval', $ids);
        $ids = array_filter($ids); // إزالة القيم الفارغة أو الصفرية

        if (!empty($ids)) {
            $deletedData = $atmsObj->deleteAtm($ids);

            if ($deletedData) {
                $Data['data'] = $deletedData;
                $Data['success'] = true;
            } else {
                $Data['data'] = null;
                $Data['msg'] = 'no_data';
                $Data['success'] = false;
            }
        } else {
            $Data['msg'] = 'No valid IDs provided';
            $Data['success'] = false;
        }

    } else {
        $Data['msg'] = 'No ID provided';
        $Data['success'] = false;
    }

    // إرسال الاستجابة النهائية
    header('Content-Type: application/json');
    echo json_encode($Data);
    exit;
}
if ($_GET['action'] == 'restoreAtm' && $_SERVER['REQUEST_METHOD'] == 'POST') {

    $rawInput = file_get_contents("php://input");
    $data = json_decode($rawInput, true);

    if (isset($data['ids'])) {

        if (is_array($data['ids'])) {
            $ids = $data['ids'];
        } else {
            $ids = explode(',', $data['ids']);
        }

        $ids = array_map('intval', $ids);
        $ids = array_filter($ids);

        if (!empty($ids)) {
            $restoredData = $atmsObj->restoreAtm($ids);

            if ($restoredData) {
                $Data['data'] = $restoredData;
                $Data['success'] = true;
            } else {
                $Data['data'] = null;
                $Data['msg'] = 'no_data';
                $Data['success'] = false;
            }
        } else {
            $Data['msg'] = 'No valid IDs provided';
            $Data['success'] = false;
        }

    } else {
        $Data['msg'] = 'No ID provided';
        $Data['success'] = false;
    }

    header('Content-Type: application/json');
    echo json_encode($Data);
    exit;
}

if ($_GET['action'] == 'countAtms') {
    $sort = isset($_GET['sort']) ? $_GET['sort'] : '';
    $searchaddress = isset($_GET['searchaddress']) ? $_GET['searchaddress'] : '';
    $searchBankId = isset($_GET['searchBankId']) ? intval($_GET['searchBankId']) : null;

    $result = $atmsObj->countAtmsByFilters($sort, $searchaddress, $searchBankId);

    echo json_encode($result, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    exit;
}




echo json_encode($Data);
