<?php

/* * *************************************************************************
 *
 *   PROJECT: Tahalya app
 *   powerd by IT PLUS Team
 *   Copyright 2020 IT Plus Inc
 *   http://it-plus.co/
 * ************************************************************************* */

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET,POST,PUT,DELETE,OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

require_once 'init.php';

$postdata = file_get_contents("php://input");
$Req = json_decode($postdata, TRUE);


if ($_GET['action'] == 'getAllLogs') {
    $atm_id = isset($_GET['atm_id']) ? $_GET['atm_id'] : null;
    $searchAtmId = isset($_GET['searchAtmId']) ? $_GET['searchAtmId'] : null;

    $logsData = $atmMaintenanceObj->getAllLogs($atm_id, $searchAtmId);
    $logsCount = count($logsData);

    if ($logsData) {
        $Data['data'] = $logsData;
        $Data['count'] = $logsCount;
        $Data['success'] = true;
    } else {
        $Data['data'] = [];
        $Data['count'] = 0;
        $Data['success'] = false;
    }
}

if ($_GET['action'] == 'addEditLog') {
    $addedData = $atmMaintenanceObj->addEditMaintenanceLog($Req);
//     echo "<pre>";
// print_r($Req);
// exit;

    if ($addedData && isset($addedData['status']) && $addedData['status'] == 200) {
        $Data['data'] = $addedData;
        $Data['success'] = true;
    } else {
        $Data['data'] = $addedData;
        $Data['msg'] = 'no_data';
        $Data['success'] = false;
    }
}

if ($_GET['action'] == 'deleteLog') {
    if (!isset($Req['ids']) || !is_array($Req['ids'])) {
        $Data = [
            "status" => 400,
            "message" => "Missing or invalid 'ids' parameter. Provide an array of maintenance log IDs."
        ];
    } else {
        $Data = $atmMaintenanceObj->deleteLogs($Req['ids']);
    }
}

if ($_GET['action'] == 'getOneLog') {
    $id = isset($_GET['id']) ? intval($_GET['id']) : 0;

    if ($id <= 0) {
        $Data['data'] = null;
        $Data['msg'] = 'Invalid or missing ID';
        $Data['success'] = false;
    } else {
        $log = $atmMaintenanceObj->getOneLog($id);

        if (isset($log['status']) && $log['status'] == 500) {
            $Data['data'] = null;
            $Data['msg'] = $log['message'];
            $Data['success'] = false;
        } else {
            $Data['data'] = $log;
            $Data['success'] = true;
        }
    }
}

if ($_GET['action'] == 'countAtmLogs') {
    $log_id = isset($_GET['log_id']) ? intval($_GET['log_id']) : null;
    $searchAtmId = isset($_GET['searchAtmId']) ? intval($_GET['searchAtmId']) : null;

    $result = $atmMaintenanceObj->countAtmLogsByFilters($log_id, $searchAtmId);

    echo json_encode($result, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    exit;
}


header('Content-Type: application/json');

echo json_encode($Data);
