<?php

/* * *************************************************************************
 *
 *   PROJECT: Tahalya app
 *   powerd by IT PLUS Team
 *   Copyright 2020 IT Plus Inc
 *   http://it-plus.co/
 * ************************************************************************* */

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET,POST,PUT,DELETE,OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

require_once 'init.php';

$postdata = file_get_contents("php://input");
$Req = json_decode($postdata, TRUE);


// if ($_GET['action'] == 'getAllArticles') {

//     $start      = isset($_GET['start']) ? intval($_GET['start']) : 0;
//     $limit      = isset($_GET['limit']) ? intval($_GET['limit']) : 10;
//     $sort       = isset($_GET['sort']) ? $_GET['sort'] : 'id';
//     $type       = isset($_GET['type']) ? strtoupper($_GET['type']) : 'DESC';
//     $lang_code  = isset($_GET['lang_code']) ? $_GET['lang_code'] : 'ar';

//     $articles = $articlesObj->getAllArticles($start, $limit, $sort, $type, $lang_code);
//     $articlesCount = is_array($articles) ? count($articles) : 0;

//     if (!empty($articles)) {
//         $Data['data'] = $articles;
//         $Data['count'] = $articlesCount;
//         $Data['success'] = true;
//     } else {
//         $Data['data'] = [];
//         $Data['count'] = 0;
//         $Data['success'] = false;
//     }
// }


if ($_GET['action'] == 'getOneArticle') {
    // ✅ قراءة البيانات من body بصيغة JSON
    $input = json_decode(file_get_contents('php://input'), true);

    $id = isset($input['id']) ? intval($input['id']) : 0;
    // $lang_code = isset($input['lang_code']) ? $input['lang_code'] : 'ar';

    $result = $articlesObj->getOneArticle($id);

    $Data['data'] = $result;
    $Data['success'] = $result['status'] == 200;
    if (!$Data['success']) $Data['msg'] = 'failed';

    echo json_encode($Data, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    exit;
}



if ($_GET['action'] == 'addEditArticle') {
    $postdata = file_get_contents("php://input");
    $Req = json_decode($postdata, true);

    $result = $articlesObj->addEditArticle($Req);

    if (isset($result['status']) && $result['status'] == 500) {
        $Data['data'] = $result;
        $Data['success'] = false;
        $Data['msg'] = 'failed';
    } else {
        // ✅ جلب جميع المقالات لتوليد ملف الإكسل المحدث
        $db = $articlesObj->mDb->connect();
        $stmt = $db->query("SELECT * FROM articles");
        $articles = $stmt->fetchAll(PDO::FETCH_ASSOC);

        $excelExport = $articlesObj->exportArticlesExcel($articles);

        $Data['data'] = [
            'article' => $result,
        ];
        $Data['success'] = true;
        $Data['msg'] = 'success';
    }

    echo json_encode($Data, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    exit;
}



if ($_GET['action'] == 'deleteArticle') {

    $ids = isset($Req['ids']) ? $Req['ids'] : [];

    $result = $articlesObj->deleteArticles($ids);

    $Data['data'] = $result;
    $Data['success'] = $result['status'] == 200;
    if (!$Data['success']) $Data['msg'] = 'failed';
    echo json_encode($Data, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);

    exit;
}

if ($_GET['action'] == 'searchArticles') {

    // استقبال البيانات من GET
    $searchTitle        = isset($_GET['searchTitle']) ? $_GET['searchTitle'] : '';
    $searchId           = isset($_GET['searchId']) ? $_GET['searchId'] : '';
    $searchSort         = isset($_GET['searchSort']) ? $_GET['searchSort'] : '';
    $lang_code          = isset($_GET['lang_code']) ? $_GET['lang_code'] : 'ar';
    $aStart             = isset($_GET['aStart']) ? intval($_GET['aStart']) : 0;
    $aLimit             = isset($_GET['aLimit']) ? intval($_GET['aLimit']) : 10;
    $type               = isset($_GET['type']) ? $_GET['type'] : 'DESC';
    $export_excel       = isset($_GET['export_excel']) && $_GET['export_excel'] == 'true';
    $searchCategoryId = [];
    if (isset($_GET['searchCategoryId'])) {
        $searchCategoryId = array_filter(array_map('intval', explode(',', $_GET['searchCategoryId'])));
    }
    $result = $articlesObj->getSearchArticles(
        $searchTitle,
        $searchId,
        $searchCategoryId,
        $searchSort,
        $lang_code,
        $aStart,
        $aLimit,
        $type,
        $export_excel
    );

    // ✅ في حالة كان التصدير مفعّل، ستكون النتيجة ملف محفوظ مسبقًا، نرجع الرابط فقط
    if ($export_excel === true && is_array($result) && isset($result['file'])) {
        echo json_encode([
            'success' => true,
            'message' => 'Excel file generated successfully',
            'file' => $result['file']
        ], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
        exit;
    }

    // ✅ الحالة العادية
    $Data['data'] = $result;
    $Data['count'] = is_array($result) ? count($result) : 0;
    $Data['success'] = true;

    echo json_encode($Data, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    exit;
}



// if ($_GET['action'] == 'searchArticles') {

//     // 🟡 محاولة جلب البيانات من JSON body
//     $rawInput = file_get_contents("php://input");
//     $body = json_decode($rawInput, true);
//     if (!is_array($body)) $body = [];

//     // 🟢 دالة مساعدة للحصول على باراميتر من JSON أو GET
//     function getParam($key, $default = null) {
//         global $body;
//         return $body[$key] ?? ($_GET[$key] ?? $default);
//     }

//     $searchTitle        = getParam('searchTitle', '');
//     $searchId           = getParam('searchId', '');
//     $searchSort         = getParam('searchSort', '');
//     $lang_code          = getParam('lang_code', 'ar');
//     $aStart             = (int) getParam('aStart', 0);
//     $aLimit             = (int) getParam('aLimit', 10);
//     $type               = strtoupper(getParam('type', 'DESC'));
//     $export_excel       = getParam('export_excel', false) === true || getParam('export_excel', '') === 'true';

//     // 🟢 استقبال الأقسام كـ array أو String
//     $searchCategoryId = getParam('searchCategoryId', []);
//     if (!is_array($searchCategoryId)) {
//         $searchCategoryId = array_filter(array_map('intval', explode(',', $searchCategoryId)));
//     } else {
//         $searchCategoryId = array_filter(array_map('intval', $searchCategoryId));
//     }


//     $result = $articlesObj->getSearchArticles(
//         $searchTitle,
//         $searchId,
//         $searchSort,
//         $lang_code,
//         $aStart,
//         $aLimit,
//         $type,
//         $export_excel,
//         $searchCategoryId
//     );


//     if ($export_excel === true && is_array($result) && isset($result['file'])) {
//         echo json_encode([
//             'success' => true,
//             'message' => 'Excel file generated successfully',
//             'file' => $result['file']
//         ], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
//         exit;
//     }


//     $Data['data'] = $result;
//     $Data['count'] = is_array($result) ? count($result) : 0;
//     $Data['success'] = true;

//     echo json_encode($Data, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
//     exit;
// }


if ($_GET['action'] == 'importArticlesExcel') {
    $response = $articlesObj->importArticlesExcel($_FILES['file']);
    echo json_encode($response, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    exit;
}

if ($_GET['action'] == 'getComments') {
    if (!isset($_GET['id_article']) || !is_numeric($_GET['id_article'])) {
        $Data = [
            "status" => 400,
            "message" => "Missing or invalid 'id_article' parameter"
        ];
    } else {
        $id_article = intval($_GET['id_article']);
        $aStart = isset($_GET['aStart']) ? intval($_GET['aStart']) : 0;
        $aLimit = isset($_GET['aLimit']) ? intval($_GET['aLimit']) : 10;

        $commentsList = $commentsObj->getCommentsWithReplies($id_article, $aStart, $aLimit);

        $Data = [
            "status" => 200,
            "success" => true,
            "msg" => "success",
            "data" => $commentsList
        ];
    }

    echo json_encode($Data, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    exit;
}


if ($_GET['action'] == 'countArticles') {
    $searchTitle = isset($_GET['searchTitle']) ? trim($_GET['searchTitle']) : '';
    $searchId = isset($_GET['searchId']) ? trim($_GET['searchId']) : '';
    $searchSort = isset($_GET['searchSort']) ? trim($_GET['searchSort']) : '';
    $lang_code = isset($_GET['lang_code']) ? trim($_GET['lang_code']) : 'ar';
    $searchCategoryId = isset($_GET['searchCategoryId']) ? $_GET['searchCategoryId'] : ''; // مثال: 1,2,5

    // دعم لإرسال قائمة من التصنيفات كـ مصفوفة أو نص مفصول بفواصل
    if (is_string($searchCategoryId)) {
        $searchCategoryId = explode(',', $searchCategoryId);
    }

    $response = $articlesObj->countArticlesByFilters(
        $searchTitle,
        $searchId,
        $searchSort,
        $lang_code,
        $searchCategoryId
    );

    echo json_encode($response, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    exit;
}

echo json_encode([
    'status' => 400,
    'message' => 'Invalid action'
], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
exit;
